/*
 Highcharts JS v10.3.1 (2022-10-31)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(w){a(w);a.Highcharts=w;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function w(a,f,c,m){a.hasOwnProperty(f)||(a[f]=m.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:f,module:a[f]}})))}a=a?a._modules:{};
w(a,"Extensions/Boost/Boostables.js",[],function(){return"area areaspline arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});w(a,"Extensions/Boost/BoostableMap.js",[a["Extensions/Boost/Boostables.js"]],function(a){var f={};a.forEach(function(a){f[a]=!0});return f});w(a,"Extensions/Boost/BoostChart.js",[a["Extensions/Boost/BoostableMap.js"],a["Core/Utilities.js"]],function(a,f){function c(b){var g=b.series,f=b.boost=b.boost||{},x=b.options.boost||{},c=B(x.seriesThreshold,
50);if(g.length>=c)return!0;if(1===g.length)return!1;x=x.allowForce;if("undefined"===typeof x)for(x=!0,c=0,b=b.xAxis;c<b.length;c++){var l=b[c];if(B(l.min,-Infinity)>B(l.dataMin,-Infinity)||B(l.max,Infinity)<B(l.dataMax,Infinity)){x=!1;break}}if("undefined"!==typeof f.forceChartBoost){if(x)return f.forceChartBoost;f.forceChartBoost=void 0}for(var m=c=b=0;m<g.length;m++){var E=g[m];l=E.options;0!==l.boostThreshold&&!1!==E.visible&&"heatmap"!==E.type&&(a[E.type]&&++b,v(E.processedXData,l.data,E.points)>=
(l.boostThreshold||Number.MAX_VALUE)&&++c)}f.forceChartBoost=x&&(b===g.length&&0<c||5<c);return f.forceChartBoost}function m(b){g(b,"predraw",function(){b.boost=b.boost||{};b.boost.forceChartBoost=void 0;b.boosted=!1;b.boost.clear&&b.boost.clear();b.boost.canvas&&b.boost.wgl&&c(b)&&b.boost.wgl.allocateBuffer(b);b.boost.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.boost.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});g(b,"render",function(){b.boost&&b.boost.wgl&&c(b)&&
b.boost.wgl.render(b)});var a=-1,v=-1;g(b.pointer,"afterGetHoverData",function(){var g=b.hoverSeries;b.boost=b.boost||{};if(b.boost.markerGroup&&g){var f=b.inverted?g.yAxis:g.xAxis;g=b.inverted?g.xAxis:g.yAxis;if(f&&f.pos!==a||g&&g.pos!==v)b.boost.markerGroup.translate(f.pos,g.pos),a=f.pos,v=g.pos}})}function v(){for(var b=[],g=0;g<arguments.length;g++)b[g]=arguments[g];var a=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return a=
b.length,!0});return a}var g=f.addEvent,B=f.pick,l=[];return{compose:function(b,g){g&&-1===l.indexOf(b)&&(l.push(b),b.prototype.callbacks.push(m));return b},getBoostClipRect:function(b,g){var a={x:b.plotLeft,y:b.plotTop,width:b.plotWidth,height:b.plotHeight};g===b&&(g=b.inverted?b.xAxis:b.yAxis,1>=g.length?(a.y=Math.min(g[0].pos,a.y),a.height=g[0].pos-b.plotTop+g[0].len):a.height=b.plotHeight);return a},isChartSeriesBoosting:c}});w(a,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",
arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}});w(a,"Extensions/Boost/WGLShader.js",[a["Core/Utilities.js"]],function(a){var f=a.clamp,c=a.error,m=a.pick;return function(){function a(a){this.errors=[];this.uLocations={};(this.gl=a)&&this.createShader()}a.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)};a.prototype.createShader=
function(){var a=this,f=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),b=function(b){return a.gl.getUniformLocation(a.shaderProgram,
b)};if(!f||!c)return this.shaderProgram=!1,this.handleErrors(),!1;this.shaderProgram=this.gl.createProgram();this.gl.attachShader(this.shaderProgram,f);this.gl.attachShader(this.shaderProgram,c);this.gl.linkProgram(this.shaderProgram);if(!this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))return this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1;this.gl.useProgram(this.shaderProgram);this.gl.bindAttribLocation(this.shaderProgram,
0,"aVertexPosition");this.pUniform=b("uPMatrix");this.psUniform=b("pSize");this.fcUniform=b("fillColor");this.isBubbleUniform=b("isBubble");this.bubbleSizeAbsUniform=b("bubbleSizeAbs");this.bubbleSizeAreaUniform=b("bubbleSizeByArea");this.uSamplerUniform=b("uSampler");this.skipTranslationUniform=b("skipTranslation");this.isCircleUniform=b("isCircle");this.isInverted=b("isInverted");return!0};a.prototype.handleErrors=function(){this.errors.length&&c("[highcharts boost] shader error - "+this.errors.join("\n"))};
a.prototype.stringToProgram=function(a,f){var g=this.gl.createShader("vertex"===f?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);this.gl.shaderSource(g,a);this.gl.compileShader(g);return this.gl.getShaderParameter(g,this.gl.COMPILE_STATUS)?g:(this.errors.push("when compiling "+f+" shader:\n"+this.gl.getShaderInfoLog(g)),!1)};a.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)};a.prototype.fillColorUniform=function(){return this.fcUniform};
a.prototype.getProgram=function(){return this.shaderProgram};a.prototype.pointSizeUniform=function(){return this.psUniform};a.prototype.perspectiveUniform=function(){return this.pUniform};a.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))};a.prototype.setBubbleUniforms=function(a,c,l,b){void 0===b&&(b=1);var g=a.options,v=Number.MAX_VALUE,E=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&a.is("bubble")){var B=
a.getPxExtremes();v=m(g.zMin,f(c,!1===g.displayNegative?g.zThreshold:-Number.MAX_VALUE,v));E=m(g.zMax,Math.max(E,l));this.gl.uniform1i(this.isBubbleUniform,1);this.gl.uniform1i(this.isCircleUniform,1);this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==a.options.sizeBy);this.gl.uniform1i(this.bubbleSizeAbsUniform,a.options.sizeByAbsoluteValue);this.setUniform("bubbleMinSize",B.minPxSize*b);this.setUniform("bubbleMaxSize",B.maxPxSize*b);this.setUniform("bubbleZMin",v);this.setUniform("bubbleZMax",
E);this.setUniform("bubbleZThreshold",a.options.zThreshold)}};a.prototype.setColor=function(a){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,a[0]/255,a[1]/255,a[2]/255,a[3])};a.prototype.setDrawAsCircle=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,a?1:0)};a.prototype.setInverted=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,a)};a.prototype.setPMatrix=function(a){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,
!1,a)};a.prototype.setPointSize=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,a)};a.prototype.setSkipTranslation=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===a?1:0)};a.prototype.setTexture=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,a)};a.prototype.setUniform=function(a,f){this.gl&&this.shaderProgram&&(a=this.uLocations[a]=this.uLocations[a]||this.gl.getUniformLocation(this.shaderProgram,
a),this.gl.uniform1f(a,f))};return a}()});w(a,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function a(a,c,m){this.buffer=!1;this.iterator=0;this.vertAttribute=this.preAllocated=!1;this.components=m||2;this.dataComponents=m;this.gl=a;this.shader=c}a.prototype.allocate=function(a){this.iterator=-1;this.preAllocated=new Float32Array(4*a)};a.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)};
a.prototype.build=function(a,c,m){var f;this.data=a||[];if(!(this.data&&0!==this.data.length||this.preAllocated))return this.destroy(),!1;this.components=m||this.components;this.buffer&&this.gl.deleteBuffer(this.buffer);this.preAllocated||(f=new Float32Array(this.data));this.buffer=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer);this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||f,this.gl.STATIC_DRAW);this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),
c);this.gl.enableVertexAttribArray(this.vertAttribute);return!0};a.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.vertAttribute=this.buffer=!1);this.iterator=0;this.components=this.dataComponents||2;this.data=[]};a.prototype.push=function(a,c,m,v){this.preAllocated&&(this.preAllocated[++this.iterator]=a,this.preAllocated[++this.iterator]=c,this.preAllocated[++this.iterator]=m,this.preAllocated[++this.iterator]=v)};a.prototype.render=function(a,c,m){var f=this.preAllocated?
this.preAllocated.length:this.data.length;if(!this.buffer||!f)return!1;if(!a||a>f||0>a)a=0;if(!c||c>f)c=f;if(a>=c)return!1;this.gl.drawArrays(this.gl[m||"POINTS"],a/this.components,(c-a)/this.components);return!0};return a}()});w(a,"Extensions/Boost/WGLRenderer.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLDrawMode.js"],a["Extensions/Boost/WGLShader.js"],a["Extensions/Boost/WGLVertexBuffer.js"]],function(a,f,c,m,v,g){var B=a.parse,l=f.doc,b=f.win,
E=c.isNumber,w=c.isObject,x=c.merge,fa=c.objectEach,R=c.pick,F={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},ha={scatter:!0,bubble:!0},J=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function c(a){this.data=[];this.height=0;this.isInited=!1;this.markerData=[];this.series=[];this.textureHandles={};this.width=0;this.postRenderCallback=a;this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}c.orthoMatrix=function(a,b){return[2/a,0,0,0,0,-(2/b),0,0,0,0,-2,0,-1,1,-1,1]};c.seriesPointCount=function(a){if(a.boosted){var k=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;k=(k?a.data:b||a.options.data).length;"treemap"===a.type?k*=12:"heatmap"===a.type?k*=6:F[a.type]&&(k*=2);return k}return 0};c.prototype.getPixelRatio=function(){return this.settings.pixelRatio||b.devicePixelRatio||
1};c.prototype.setOptions=function(a){"pixelRatio"in a||(a.pixelRatio=1);x(!0,this.settings,a)};c.prototype.allocateBuffer=function(a){var k=this.vbuffer,b=0;this.settings.usePreallocated&&(a.series.forEach(function(a){a.boosted&&(b+=c.seriesPointCount(a))}),k&&k.allocate(b))};c.prototype.allocateBufferForSingleSeries=function(a){var k=this.vbuffer,b=0;this.settings.usePreallocated&&(a.boosted&&(b=c.seriesPointCount(a)),k&&k.allocate(b))};c.prototype.clear=function(){var a=this.gl;a&&a.clear(a.COLOR_BUFFER_BIT|
a.DEPTH_BUFFER_BIT)};c.prototype.pushSeriesData=function(a,b){var k=this,c=this.data,g=this.settings,e=this.vbuffer,n=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),p=a.chart,q=a.options,K=!!q.stacking,ia=q.data,d=a.xAxis.getExtremes(),O=d.min,f=d.max;d=a.yAxis.getExtremes();var l=d.min,m=d.max,v=a.xData||q.xData||a.processedXData,E=a.yData||q.yData||a.processedYData,x=a.zData||q.zData||a.processedZData,ca=a.yAxis,H=a.xAxis,W=!v||0===v.length,I=q.connectNulls;d=a.points||!1;var t=K?a.data:
v||ia,S={x:Number.MAX_VALUE,y:0},P={x:-Number.MAX_VALUE,y:0},h="undefined"===typeof p.index,r=F[a.type],Fa=q.zoneAxis||"y",da=q.zones||!1,X=q.threshold,ea=this.getPixelRatio(),sa=a.chart.plotWidth,ka=!1,la=!1,aa,U,ya=0,ta=!1,C,y,G,J,z=-1,T=!1,Y=!1,M,R=!1,qa=!1,A=!1,ua=!1,va=!0,ra=!0,N=!1,D=!1,ba=0;if(!(q.boostData&&0<q.boostData.length)){q.gapSize&&(D="value"!==q.gapUnit?q.gapSize*a.closestPointRange:q.gapSize);if(da){var ma=[];da.forEach(function(a,b){if(a.color){var h=B(a.color).rgba;h[0]/=255;
h[1]/=255;h[2]/=255;ma[b]=h;N||"undefined"!==typeof a.value||(N=h)}});N||(v=a.pointAttribs&&a.pointAttribs().fill||a.color,N=B(v).rgba,N[0]/=255,N[1]/=255,N[2]/=255)}p.inverted&&(sa=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;var V=function(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))},Q=function(a,h,r,n,k){void 0===n&&(n=1);V(k);1===ea||g.useGPUTranslations&&!b.skipTranslation||(a*=ea,h*=ea,n*=ea);g.usePreallocated&&e?(e.push(a,
h,r?1:0,n),ba+=4):(c.push(a),c.push(h),c.push(r?ea:0),c.push(n))},Ba=function(){b.segments.length&&(b.segments[b.segments.length-1].to=c.length||ba)},za=function(){b.segments.length&&b.segments[b.segments.length-1].from===(c.length||ba)||(Ba(),b.segments.push({from:c.length||ba}))},Ca=function(a,h,b,e,r){V(r);Q(a+b,h);V(r);Q(a,h);V(r);Q(a,h+e);V(r);Q(a,h+e);V(r);Q(a+b,h+e);V(r);Q(a+b,h)};za();if(d&&0<d.length)b.skipTranslation=!0,b.drawMode="TRIANGLES",d[0].node&&d[0].node.levelDynamic&&d.sort(function(a,
h){if(a.node){if(a.node.levelDynamic>h.node.levelDynamic)return 1;if(a.node.levelDynamic<h.node.levelDynamic)return-1}return 0}),d.forEach(function(h){var b=h.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==h.y&&h.shapeArgs){var e=h.shapeArgs;b=e.x;b=void 0===b?0:b;var r=e.y;r=void 0===r?0:r;var n=e.width;n=void 0===n?0:n;e=e.height;e=void 0===e?0:e;var k=p.styledMode?h.series.colorAttribs(h):k=h.series.pointAttribs(h);h=k["stroke-width"]||0;A=B(k.fill).rgba;A[0]/=255;A[1]/=255;A[2]/=255;a.is("treemap")&&
(h=h||1,U=B(k.stroke).rgba,U[0]/=255,U[1]/=255,U[2]/=255,Ca(b,r,n,e,U),h/=2);a.is("heatmap")&&p.inverted&&(b=H.len-b,r=ca.len-r,n=-n,e=-e);Ca(b+h,r+h,n-2*h,e-2*h,A)}});else{for(d=function(){G=t[++z];if("undefined"===typeof G)return"continue";if(h)return"break";var e=ia&&ia[z];!W&&w(e,!0)&&e.color&&(A=B(e.color).rgba,A[0]/=255,A[1]/=255,A[2]/=255);W?(C=G[0],y=G[1],t[z+1]&&(Y=t[z+1][0]),t[z-1]&&(T=t[z-1][0]),3<=G.length&&(J=G[2],G[2]>b.zMax&&(b.zMax=G[2]),G[2]<b.zMin&&(b.zMin=G[2]))):(C=G,y=E[z],t[z+
1]&&(Y=t[z+1]),t[z-1]&&(T=t[z-1]),x&&x.length&&(J=x[z],x[z]>b.zMax&&(b.zMax=x[z]),x[z]<b.zMin&&(b.zMin=x[z])));if(!I&&(null===C||null===y))return za(),"continue";Y&&Y>=O&&Y<=f&&(R=!0);T&&T>=O&&T<=f&&(qa=!0);n?(W&&(y=G.slice(1,3)),M=y[0],y=y[1]):K&&(C=G.x,y=G.stackY,M=y-G.y);null!==l&&"undefined"!==typeof l&&null!==m&&"undefined"!==typeof m&&(va=y>=l&&y<=m);C>f&&P.x<f&&(P.x=C,P.y=y);C<O&&S.x>O&&(S.x=C,S.y=y);if(null===y&&I)return"continue";if(null===y||!va&&!R&&!qa)return za(),"continue";(Y>=O||C>=
O)&&(T<=f||C<=f)&&(ua=!0);if(!ua&&!R&&!qa)return"continue";D&&C-T>D&&za();if(da){var k;da.some(function(a,h){var b=da[h-1];return"x"===Fa?"undefined"!==typeof a.value&&C<=a.value?(ma[h]&&(!b||C>=b.value)&&(k=ma[h]),!0):!1:"undefined"!==typeof a.value&&y<=a.value?(ma[h]&&(!b||y>=b.value)&&(k=ma[h]),!0):!1});A=k||N||A}if(!g.useGPUTranslations&&(b.skipTranslation=!0,C=H.toPixels(C,!0),y=ca.toPixels(y,!0),C>sa&&"POINTS"===b.drawMode))return"continue";b.hasMarkers&&ua&&!1!==ka&&(a.closestPointRangePx=
Math.min(a.closestPointRangePx,Math.abs(C-ka)));if(!g.useGPUTranslations&&!g.usePreallocated&&ka&&1>Math.abs(C-ka)&&la&&1>Math.abs(y-la))return g.debug.showSkipSummary&&++ya,"continue";if(r){aa=M;if(!1===M||"undefined"===typeof M)aa=0>y?y:0;n||K||(aa=Math.max(null===X?l:X,l));g.useGPUTranslations||(aa=ca.toPixels(aa,!0));Q(C,aa,0,0,A)}q.step&&!ra&&Q(C,la,0,2,A);Q(C,y,0,"bubble"===a.type?J||1:2,A);ka=C;la=y;ta=!0;ra=!1};z<t.length-1&&"break"!==d(););g.debug.showSkipSummary&&console.log("skipped points:",
ya);d=function(a,h){g.useGPUTranslations||(b.skipTranslation=!0,a.x=H.toPixels(a.x,!0),a.y=ca.toPixels(a.y,!0));h?k.data=[a.x,a.y,0,2].concat(k.data):Q(a.x,a.y,0,2)};ta||!1===I||"line_strip"!==a.drawMode||(S.x<Number.MAX_VALUE&&d(S,!0),P.x>-Number.MAX_VALUE&&d(P))}Ba()}};c.prototype.pushSeries=function(a){var b=this.markerData,k=this.series,c=this.settings;0<k.length&&k[k.length-1].hasMarkers&&(k[k.length-1].markerTo=b.length);c.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");
b={segments:[],markerFrom:b.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:m[a.type]||"LINE_STRIP"};a.index>=k.length?k.push(b):k[a.index]=b;this.pushSeriesData(a,b);c.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")};c.prototype.flush=function(){var a=this.vbuffer;this.data=[];this.markerData=[];this.series=[];a&&a.destroy()};c.prototype.setXAxis=function(a){var b=
this.shader;if(b){var k=this.getPixelRatio();b.setUniform("xAxisTrans",a.transA*k);b.setUniform("xAxisMin",a.min);b.setUniform("xAxisMinPad",a.minPixelPadding*k);b.setUniform("xAxisPointRange",a.pointRange);b.setUniform("xAxisLen",a.len*k);b.setUniform("xAxisPos",a.pos*k);b.setUniform("xAxisCVSCoord",!a.horiz);b.setUniform("xAxisIsLog",!!a.logarithmic);b.setUniform("xAxisReversed",!!a.reversed)}};c.prototype.setYAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();b.setUniform("yAxisTrans",
a.transA*c);b.setUniform("yAxisMin",a.min);b.setUniform("yAxisMinPad",a.minPixelPadding*c);b.setUniform("yAxisPointRange",a.pointRange);b.setUniform("yAxisLen",a.len*c);b.setUniform("yAxisPos",a.pos*c);b.setUniform("yAxisCVSCoord",!a.horiz);b.setUniform("yAxisIsLog",!!a.logarithmic);b.setUniform("yAxisReversed",!!a.reversed)}};c.prototype.setThreshold=function(a,b){var c=this.shader;c&&(c.setUniform("hasThreshold",a),c.setUniform("translatedThreshold",b))};c.prototype.renderChart=function(b){var k=
this,u=this.gl,l=this.settings,m=this.shader,e=this.vbuffer,n=this.getPixelRatio();if(b)this.width=b.chartWidth*n,this.height=b.chartHeight*n;else return!1;var p=this.height,q=this.width;if(!(u&&m&&q&&p))return!1;l.debug.timeRendering&&console.time("gl rendering");u.canvas.width=q;u.canvas.height=p;m.bind();u.viewport(0,0,q,p);m.setPMatrix(c.orthoMatrix(q,p));1<l.lineWidth&&!f.isMS&&u.lineWidth(l.lineWidth);e&&(e.build(this.data,"aVertexPosition",4),e.bind());m.setInverted(b.inverted);this.series.forEach(function(c,
q){var d=c.series.options,f=d.marker,p="undefined"!==typeof d.lineWidth?d.lineWidth:1,K=d.threshold,v=E(K),x=c.series.yAxis.getThreshold(K);K=R(d.marker?d.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10));f=k.textureHandles[f&&f.symbol||c.series.symbol]||k.textureHandles.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to&&(f.isReady&&(u.bindTexture(u.TEXTURE_2D,f.handle),m.setTexture(f.handle)),b.styledMode?
f=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):(f="POINTS"===c.drawMode&&c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,d.colorByPoint&&(f=c.series.chart.options.colors[q])),c.series.fillOpacity&&d.fillOpacity&&(f=(new a(f)).setOpacity(R(d.fillOpacity,1)).get()),f=B(f).rgba,l.useAlpha||(f[3]=1),"LINES"===c.drawMode&&l.useAlpha&&1>f[3]&&(f[3]/=10),"add"===d.boostBlending?(u.blendFunc(u.SRC_ALPHA,u.ONE),u.blendEquation(u.FUNC_ADD)):"mult"===d.boostBlending||"multiply"===
d.boostBlending?u.blendFunc(u.DST_COLOR,u.ZERO):"darken"===d.boostBlending?(u.blendFunc(u.ONE,u.ONE),u.blendEquation(u.FUNC_MIN)):u.blendFuncSeparate(u.SRC_ALPHA,u.ONE_MINUS_SRC_ALPHA,u.ONE,u.ONE_MINUS_SRC_ALPHA),m.reset(),0<c.colorData.length?(m.setUniform("hasColor",1),q=new g(u,m),q.build(c.colorData,"aColor",4),q.bind()):u.disableVertexAttribArray(u.getAttribLocation(m.getProgram(),"aColor")),m.setColor(f),k.setXAxis(c.series.xAxis),k.setYAxis(c.series.yAxis),k.setThreshold(v,x),"POINTS"===c.drawMode&&
m.setPointSize(2*R(d.marker&&d.marker.radius,.5)*n),m.setSkipTranslation(c.skipTranslation),"bubble"===c.series.type&&m.setBubbleUniforms(c.series,c.zMin,c.zMax,n),m.setDrawAsCircle(ha[c.series.type]||!1),e)){if(0<p||"LINE_STRIP"!==c.drawMode)for(p=0;p<c.segments.length;p++)e.render(c.segments[p].from,c.segments[p].to,c.drawMode);if(c.hasMarkers&&K)for(m.setPointSize(2*R(d.marker&&d.marker.radius,5)*n),m.setDrawAsCircle(!0),p=0;p<c.segments.length;p++)e.render(c.segments[p].from,c.segments[p].to,
"POINTS")}});l.debug.timeRendering&&console.timeEnd("gl rendering");this.postRenderCallback&&this.postRenderCallback(this);this.flush()};c.prototype.render=function(a){var b=this;this.clear();if(a.renderer.forExport)return this.renderChart(a);this.isInited?this.renderChart(a):setTimeout(function(){b.render(a)},1)};c.prototype.setSize=function(a,b){var f=this.shader;!f||this.width===a&&this.height===b||(this.width=a,this.height=b,f.bind(),f.setPMatrix(c.orthoMatrix(a,b)))};c.prototype.init=function(a,
b){var c=this,f=this.settings;this.isInited=!1;if(!a)return!1;f.debug.timeSetup&&console.time("gl setup");for(var k=0;k<J.length&&!(this.gl=a.getContext(J[k],{}));++k);var e=this.gl;if(e)b||this.flush();else return!1;e.enable(e.BLEND);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);e.disable(e.DEPTH_TEST);e.depthFunc(e.LESS);a=this.shader=new v(e);if(!a)return!1;this.vbuffer=new g(e,a);a=function(a,b){var n={isReady:!1,texture:l.createElement("canvas"),handle:e.createTexture()},f=n.texture.getContext("2d");
c.textureHandles[a]=n;n.texture.width=512;n.texture.height=512;f.mozImageSmoothingEnabled=!1;f.webkitImageSmoothingEnabled=!1;f.msImageSmoothingEnabled=!1;f.imageSmoothingEnabled=!1;f.strokeStyle="rgba(255, 255, 255, 0)";f.fillStyle="#FFF";b(f);try{e.activeTexture(e.TEXTURE0),e.bindTexture(e.TEXTURE_2D,n.handle),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),
e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.bindTexture(e.TEXTURE_2D,null),n.isReady=!0}catch(oa){}};a("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});a("square",function(a){a.fillRect(0,0,512,512)});a("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});a("triangle",function(a){a.beginPath();a.moveTo(0,
512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});a("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});this.isInited=!0;f.debug.timeSetup&&console.timeEnd("gl setup");return!0};c.prototype.destroy=function(){var a=this.gl,b=this.shader,c=this.vbuffer;this.flush();c&&c.destroy();b&&b.destroy();a&&(fa(this.textureHandles,function(b){b.handle&&a.deleteTexture(b.handle)}),a.canvas.width=1,a.canvas.height=1)};return c}()});
w(a,"Extensions/Boost/BoostSeries.js",[a["Extensions/Boost/BoostableMap.js"],a["Extensions/Boost/Boostables.js"],a["Extensions/Boost/BoostChart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLRenderer.js"]],function(a,f,c,m,v,g,B){function l(a,b){var h=b.boost;a&&h&&h.target&&h.canvas&&!oa(b.chart)&&a.allocateBufferForSingleSeries(b)}function b(a){return W(a&&a.options&&a.options.boost&&a.options.boost.enabled,!0)}function E(a,b){var h=a.constructor,e=
a.seriesGroup||b.group,c=a.chartWidth,r=a.chartHeight,f=a,n="undefined"!==typeof SVGForeignObjectElement;f=oa(a)?a:b;var d=f.boost=f.boost||{};n=!1;P||(P=O.createElement("canvas"));d.target||(d.canvas=P,a.renderer.forExport||!n?(f.renderTarget=d.target=a.renderer.image("",0,0,c,r).addClass("highcharts-boost-canvas").add(e),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize();
d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=a.renderer.createElement("foreignObject").add(e),f.renderTarget=d.target=O.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height;d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){c=a.chartWidth;r=a.chartHeight;(d.targetFo||
d.target).attr({x:0,y:0,width:c,height:r}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});f instanceof h&&f.boost.markerGroup.translate(a.plotLeft,a.plotTop)},d.clipRect=a.renderer.clipRect(),(d.targetFo||d.target).clip(d.clipRect),f instanceof h&&(f.boost.markerGroup=f.renderer.g().add(e).translate(b.xAxis.pos,b.yAxis.pos)));d.canvas.width=c;d.canvas.height=r;d.clipRect&&d.clipRect.attr(K(a,f));d.resize();d.clear();d.wgl||(d.wgl=new B(function(a){a.settings.debug.timeBufferCopy&&console.time("buffer copy");
d.copy();a.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||pa("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(a.options.boost||{}),f instanceof h&&d.wgl.allocateBuffer(a));d.wgl.setSize(c,r);return d.wgl}function w(a){var b=a.points;if(b){var h=void 0,e=void 0;for(e=0;e<b.length;e+=1)(h=b[e])&&h.destroyElements&&h.destroyElements()}["graph","area","tracker"].forEach(function(b){var h=a[b];h&&(a[b]=h.destroy())});a.getZonesGraphs&&a.getZonesGraphs([["graph",
"highcharts-graph"]]).forEach(function(b){var h=a[b[0]];h&&(a[b[0]]=h.destroy())})}function x(a,b,e,c,d,f){d=d||0;c=c||3E3;for(var h=d+c,r=!0;r&&d<h&&d<a.length;)r=b(a[d],d),++d;r&&(d<a.length?f?x(a,b,e,c,d,f):Z.requestAnimationFrame?Z.requestAnimationFrame(function(){x(a,b,e,c,d)}):setTimeout(x,0,a,b,e,c,d):e&&e())}function fa(a){a.boost=a.boost||{getPoint:function(b){return k(a,b)}};var b=a.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(function(e){b.push({prop:e,val:a[e],own:Object.hasOwnProperty.call(a,
e)})});a.allowDG=!1;a.directTouch=!1;a.stickyTracking=!0;a.finishedAnimating=!0;a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}function R(a){var b=a.boost;b&&((b.altered||[]).forEach(function(b){b.own?a[b.prop]=b.val:delete a[b.prop]}),b.clear&&b.clear())}function F(a,b){var e=a.options,c=a.xAxis&&a.xAxis.options,d=a.yAxis&&a.yAxis.options;a=a.colorAxis&&a.colorAxis.options;return e.data.length>(e.boostThreshold||Number.MAX_VALUE)&&H(d.min)&&H(d.max)&&(!b||H(c.min)&&H(c.max))&&(!a||
H(a.min)&&H(a.max))}function ha(){var a=this,b=a.chart;b.boost&&b.boost.markerGroup===a.markerGroup&&(a.markerGroup=null);b.hoverPoints&&(b.hoverPoints=b.hoverPoints.filter(function(b){return b.series===a}));b.hoverPoint&&b.hoverPoint.series===a&&(b.hoverPoint=null)}function J(){var a=this.boost;a&&a.canvas&&a.target&&(a.wgl&&a.wgl.clear(),a.clear&&a.clear())}function wa(a){var b=a.boost;b&&b.canvas&&b.target&&b.wgl&&!oa(a.chart)&&b.wgl.render(a.chart)}function k(a,b){var e=a.options,c=a.xAxis,d=
a.pointClass;if(b instanceof d)return b;e=a.xData||e.xData||a.processedXData||!1;d=(new d).init(a,a.options.data[b.i],e?e[b.i]:void 0);d.category=W(c.categories?c.categories[d.x]:d.x,d.x);d.dist=b.dist;d.distX=b.distX;d.plotX=b.plotX;d.plotY=b.plotY;d.index=b.i;d.percentage=b.percentage;d.isInside=a.isPointInside(d);return d}function ia(){function a(a,b){var e="undefined"===typeof d.index,h=!1,n=!0;if("undefined"===typeof a)return!0;if(!e){if(I){var r=a[0];var p=a[1]}else r=a,p=g[b];if(z)I&&(p=a.slice(1,
3)),h=p[0],p=p[1];else if(B){r=a.x;p=a.stackY;h=p-a.y;var k=a.percentage}M||(n=(p||0)>=K&&p<=O);if(null!==p&&r>=q&&r<=m&&n)if(a=c.toPixels(r,!0),u){if("undefined"===typeof D||a===H){z||(h=p);if("undefined"===typeof ba||p>N)N=p,ba=b;if("undefined"===typeof D||h<Z)Z=h,D=b}F&&a===H||("undefined"!==typeof D&&(p=f.toPixels(N,!0),J=f.toPixels(Z,!0),V(a,p,ba,k),J!==p&&V(a,J,D,k)),D=ba=void 0,H=a)}else p=Math.ceil(f.toPixels(p,!0)),V(a,p,b,k)}return!e}var b=this,e=this.options||{},d=this.chart,c=this.xAxis,
f=this.yAxis,n=e.xData||this.processedXData,g=e.yData||this.processedYData,p=e.data,k=c.getExtremes(),q=k.min,m=k.max;k=f.getExtremes();var K=k.min,O=k.max,t={},u=!!this.sampling,v=!1!==e.enableMouseTracking;k=e.threshold;var z=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),B=!!e.stacking,L=this.cropStart||0,M=this.requireSorting,I=!n,F="x"===e.findNearestPointBy,A=this.xData||this.options.xData||this.processedXData||!1;e=!1;var H,J=f.getThreshold(k),Z,N,D,ba;e=E(d,this);d.boosted=
!0;if(this.visible){(this.points||this.graph)&&w(this);oa(d)?(this.markerGroup&&this.markerGroup!==d.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=d.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(d.boost&&this.markerGroup===d.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,d.seriesGroup));var ma=this.points=[],V=function(a,b,e,h){a=Math.ceil(a);S=F?a:a+","+
b;v&&!t[S]&&(t[S]=!0,d.inverted&&(a=c.len-a,b=f.len-b),ma.push({x:A?A[L+e]:!1,clientX:a,plotX:a,plotY:b,i:L+e,percentage:h}))};this.buildKDTree=Da;e&&(l(e,this),e.pushSeries(this),wa(this));var Q=e.settings;e=function(){Ea(b,"renderedCanvas");delete b.buildKDTree;b.buildKDTree();Q.debug.timeKDTree&&console.timeEnd("kd tree building")};d.renderer.forExport||(Q.debug.timeKDTree&&console.time("kd tree building"),x(B?this.data:n||p,a,e))}}function u(a){var b=this.series,e=this.plotX||0,d=this.plotY||
0,c=b.chart.inverted;b.boosted&&c&&(this.plotX=b.yAxis.len-d,this.plotY=b.xAxis.len-e);var f=a.apply(this,[].slice.call(arguments,1));b.boosted&&c&&(this.plotX=e,this.plotY=d);return f}function na(a){var b=!0;this.chart.options&&this.chart.options.boost&&(b="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!b||!this.boosted)return a.call(this);this.chart.boosted=!0;if(a=E(this.chart,this))l(a,this),a.pushSeries(this);wa(this)}function xa(e,d,c){function f(e){var d=
this.options.stacking&&("translate"===c||"generatePoints"===c);this.boosted&&!d&&b(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&a[this.type]&&0!==this.options.boostThreshold?"render"===c&&this.renderCanvas&&this.renderCanvas():e.call(this)}I(e,c,f);"translate"===c&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(a){d[a]&&I(d[a].prototype,c,f)})}function e(a){return this.boosted&&F(this)?{}:a.apply(this,[].slice.call(arguments,1))}function n(a,b){var e=b.plotX||
0,d=b.plotY||0,c=this.chart.inverted;this.boosted&&c&&(b.plotX=this.yAxis.len-d,b.plotY=this.xAxis.len-e);var f=a.apply(this,[].slice.call(arguments,1));this.boosted&&c&&(b.plotX=e,b.plotY=d);return f}function p(e){var d=this,c=this.options.data,f=function(a){return d.forceCrop?!1:oa(d.chart)||(a?a.length:0)>=(d.options.boostThreshold||Number.MAX_VALUE)};b(this.chart)&&a[this.type]?(f(c)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&F(this,!0)||(e.apply(this,[].slice.call(arguments,
1)),c=this.processedXData),(this.boosted=f(c))?(c=void 0,this.options.data&&this.options.data.length&&(c=this.getFirstValidPoint(this.options.data),H(c)||ca(c)||pa(12,!1,this.chart)),fa(this)):R(this)):e.apply(this,[].slice.call(arguments,1))}function q(a){var b=a.apply(this,[].slice.call(arguments,1));return this.boost&&b?this.boost.getPoint(b):b}var K=c.getBoostClipRect,oa=c.isChartSeriesBoosting,d=m.getOptions,O=v.doc,Da=v.noop,Z=v.win,L=g.addEvent,pa=g.error,ja=g.extend,Ea=g.fireEvent,ca=g.isArray,
H=g.isNumber,W=g.pick,I=g.wrap,t=[],S,P;return{compose:function(a,b,c){var h=a.prototype.pointClass;-1===t.indexOf(h)&&(t.push(h),I(h.prototype,"haloPath",u));if(-1===t.indexOf(a)){t.push(a);L(a,"destroy",ha);L(a,"hide",J);var g=a.prototype;c&&(g.renderCanvas=ia);I(g,"getExtremes",e);I(g,"markerAttribs",n);I(g,"processData",p);I(g,"searchPoint",q);["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(a){return xa(g,b,a)})}if(-1===t.indexOf(d)){t.push(d);var k=d().plotOptions;
f.forEach(function(a){var e=k[a];e&&(e.boostThreshold=5E3,e.boostData=[],b[a].prototype.fillOpacity=!0)})}if(c){var m=b.area,l=b.areaspline,K=b.bubble;c=b.column;h=b.heatmap;var r=b.scatter,O=b.treemap;m&&-1===t.indexOf(m)&&(t.push(m),ja(m.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));l&&-1===t.indexOf(l)&&(t.push(l),ja(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));K&&-1===t.indexOf(K)&&(t.push(K),m=K.prototype,delete m.buildKDTree,I(m,"markerAttribs",function(a){return this.boosted?!1:a.apply(this,
[].slice.call(arguments,1))}));c&&-1===t.indexOf(c)&&(t.push(c),ja(c.prototype,{fill:!0,sampling:!0}));r&&-1===t.indexOf(r)&&(t.push(r),r.prototype.fill=!0);[h,O].forEach(function(a){a&&-1===t.indexOf(a)&&(t.push(a),I(a.prototype,"drawPoints",na))})}return a},destroyGraphics:w,getPoint:k}});w(a,"Extensions/BoostCanvas.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],
a["Core/Utilities.js"]],function(a,f,c,m,v,g,B,l){var b=a.getBoostClipRect,w=a.isChartSeriesBoosting,E=f.destroyGraphics,x=m.parse,fa=v.doc,R=v.noop,F=B.seriesTypes,ha=l.addEvent,J=l.extend,wa=l.fireEvent,k=l.isNumber,ia=l.merge,u=l.pick,na=l.wrap,xa;return function(){v.seriesTypes.heatmap&&na(v.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,f=this.xAxis,g=this.yAxis;b?(this.points.forEach(function(e){var d=e.plotY;if("undefined"!==
typeof d&&!isNaN(d)&&null!==e.y&&b){var n=e.shapeArgs||{};d=n.x;d=void 0===d?0:d;var p=n.y;p=void 0===p?0:p;var k=n.width;k=void 0===k?0:k;n=n.height;n=void 0===n?0:n;e=a.styledMode?e.series.colorAttribs(e):e.series.pointAttribs(e);b.fillStyle=e.fill;c?b.fillRect(g.len-p+f.left,f.len-d+g.top,-n,-k):b.fillRect(d+f.left,p+g.top,k,n)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});J(g.prototype,{getContext:function(){var a=
this.chart,c=w(a)?a:this,f=c===a?a.seriesGroup:a.seriesGroup||this.group,g=a.chartWidth,k=a.chartHeight,m=function(a,b,e,c,d,f,n){a.call(this,e,b,c,d,f,n)},d=c.boost=c.boost||{};var l=d.targetCtx;d.canvas||(d.canvas=fa.createElement("canvas"),d.target=a.renderer.image("",0,0,g,k).addClass("highcharts-boost-canvas").add(f),l=d.targetCtx=d.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){na(l,a,m)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},
d.clear=function(){l.clearRect(0,0,d.canvas.width,d.canvas.height);c===d.target&&d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.clipRect=a.renderer.clipRect(),d.target.clip(d.clipRect));d.canvas.width!==g&&(d.canvas.width=g);d.canvas.height!==k&&(d.canvas.height=k);d.target.attr({x:0,y:0,width:g,height:k,style:"pointer-events: none",href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});
d.clipRect&&d.clipRect.attr(b(a,c));return l},canvasToSVG:function(){w(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,f=this.xAxis,g=this.yAxis,B=(c.options.boost||{}).timeRendering||!1,d=0,w=a.processedXData,F=a.processedYData,Z=b.data,L=f.getExtremes(),pa=L.min,ja=L.max;L=g.getExtremes();
var fa=L.min,ca=L.max,H={},W,I=!!a.sampling,t=b.marker&&b.marker.radius,S=this.cvsDrawPoint,P=b.lineWidth?this.cvsLineTo:void 0,h=t&&1>=t?this.cvsMarkerSquare:this.cvsMarkerCircle,r=this.cvsStrokeBatch||1E3,na=!1!==b.enableMouseTracking,da;L=b.threshold;var X=g.getThreshold(L),ea=k(L),sa=X,ka=this.fill,la=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),aa=!!b.stacking,U=a.cropStart||0;L=c.options.loading;var ya=a.requireSorting,ta,C=b.connectNulls,y=!w,G,Aa,z,T,Y,M=aa?a.data:w||Z,Ga=a.fillOpacity?
m.parse(a.color).setOpacity(u(b.fillOpacity,.75)).get():a.color,qa=function(){ka?(D.fillStyle=Ga,D.fill()):(D.strokeStyle=a.color,D.lineWidth=b.lineWidth,D.stroke())},A=function(b,e,f,g){0===d&&(D.beginPath(),P&&(D.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(e+=c.scroller.top,f&&(f+=c.scroller.top)):e+=c.plotTop;b+=c.plotLeft;ta?D.moveTo(b,e):S?S(D,b,e,f,da):P?P(D,b,e):h&&h.call(a,D,b,e,t,g);d+=1;d===r&&(qa(),d=0);da={clientX:b,plotY:e,yBottom:f}},ua="x"===
b.findNearestPointBy,va=this.xData||this.options.xData||this.processedXData||!1,ra=function(a,b,d){Y=ua?a:a+","+b;na&&!H[Y]&&(H[Y]=!0,c.inverted&&(a=f.len-a,b=g.len-b),N.push({x:va?va[U+d]:!1,clientX:a,plotX:a,plotY:b,i:U+d}))};w=this.boost||{};w.target&&w.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});(this.points||this.graph)&&E(this);a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);
a.markerGroup=a.group;ha(a,"destroy",function(){a.markerGroup=null});var N=this.points=[];var D=this.getContext();a.buildKDTree=R;w.clear&&w.clear();this.visible&&(99999<Z.length&&(c.options.loading=ia(L,{labelStyle:{backgroundColor:x("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),l.clearTimeout(xa),c.showLoading("Drawing..."),c.options.loading=L),B&&console.time("canvas rendering"),v.eachAsync(M,function(b,d){var e=!1,h=!1,k=!1,n=!1,
p="undefined"===typeof c.index,m=!0;if(!p){if(y){var l=b[0];var q=b[1];M[d+1]&&(k=M[d+1][0]);M[d-1]&&(n=M[d-1][0])}else l=b,q=F[d],M[d+1]&&(k=M[d+1]),M[d-1]&&(n=M[d-1]);k&&k>=pa&&k<=ja&&(e=!0);n&&n>=pa&&n<=ja&&(h=!0);if(la){y&&(q=b.slice(1,3));var r=q[0];q=q[1]}else aa&&(l=b.x,q=b.stackY,r=q-b.y);b=null===q;ya||(m=q>=fa&&q<=ca);if(!b&&(l>=pa&&l<=ja&&m||e||h))if(l=Math.round(f.toPixels(l,!0)),I){if("undefined"===typeof z||l===W){la||(r=q);if("undefined"===typeof T||q>Aa)Aa=q,T=d;if("undefined"===typeof z||
r<G)G=r,z=d}l!==W&&("undefined"!==typeof z&&(q=g.toPixels(Aa,!0),X=g.toPixels(G,!0),A(l,ea?Math.min(q,sa):q,ea?Math.max(X,sa):X,d),ra(l,q,T),X!==q&&ra(l,X,z)),z=T=void 0,W=l)}else q=Math.round(g.toPixels(q,!0)),A(l,q,X,d),ra(l,q,d);ta=b&&!C;0===d%5E4&&(a.boost&&a.boost.copy?a.boost.copy():a.chart.boost&&a.chart.boost.copy&&a.chart.boost.copy())}return!p},function(){var b=c.loadingDiv,d=c.loadingShown;qa();a.canvasToSVG();B&&console.timeEnd("canvas rendering");wa(a,"renderedCanvas");d&&(J(b.style,
{transition:"opacity 250ms",opacity:0}),c.loadingShown=!1,xa=setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});F.scatter.prototype.cvsMarkerCircle=function(a,b,c,f){a.moveTo(b,c);a.arc(b,c,f,0,2*Math.PI,!1)};F.scatter.prototype.cvsMarkerSquare=function(a,b,c,f){a.rect(b-f,c-f,2*f,2*f)};F.scatter.prototype.fill=!0;F.bubble&&(F.bubble.prototype.cvsMarkerCircle=
function(a,b,c,f,g){a.moveTo(b,c);a.arc(b,c,this.radii&&this.radii[g],0,2*Math.PI,!1)},F.bubble.prototype.cvsStrokeBatch=1);J(F.area.prototype,{cvsDrawPoint:function(a,b,c,f,g){g&&b!==g.clientX&&(a.moveTo(g.clientX,g.yBottom),a.lineTo(g.clientX,g.plotY),a.lineTo(b,c),a.lineTo(b,f))},fill:!0,fillOpacity:!0,sampling:!0});J(F.column.prototype,{cvsDrawPoint:function(a,b,c,f){a.rect(b-1,c,1,f-c)},fill:!0,sampling:!0});c.prototype.callbacks.push(function(a){ha(a,"predraw",function(){var a=this.boost||{};
a.target&&a.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});a.canvas&&a.canvas.getContext("2d").clearRect(0,0,a.canvas.width,a.canvas.height)});ha(a,"render",function(){a.boost&&a.boost.copy&&a.boost.copy()})})}});w(a,"masters/modules/boost-canvas.src.js",[],function(){})});
//# sourceMappingURL=boost-canvas.js.map