/*
 Highcharts Gantt JS v10.3.1 (2022-10-31)

 Pathfinder

 (c) 2016-2021 ystein Moseng

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/pathfinder",["highcharts"],function(w){a(w);a.Highcharts=w;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function w(a,x,u,v){a.hasOwnProperty(x)||(a[x]=v.apply(null,u),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:x,module:a[x]}})))}a=a?a._modules:{};w(a,
"Extensions/ArrowSymbols.js",[a["Core/Renderer/SVG/SVGRenderer.js"]],function(a){function x(a,d,n,q){return[["M",a,d+q/2],["L",a+n,d],["L",a,d+q/2],["L",a+n,d+q]]}function u(a,d,n,q){return[["M",a+n,d],["L",a,d+q/2],["L",a+n,d+q],["Z"]]}function v(a,d,n,q){return u(a,d,n/2,q)}a=a.prototype.symbols;a.arrow=x;a["arrow-filled"]=u;a["arrow-filled-half"]=v;a["arrow-half"]=function(a,d,n,q){return x(a,d,n/2,q)};a["triangle-left"]=u;a["triangle-left-half"]=v;return a});w(a,"Gantt/Connection.js",[a["Core/Defaults.js"],
a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,x,u,v){function C(a){var l=a.shapeArgs;return l?{xMin:l.x||0,xMax:(l.x||0)+(l.width||0),yMin:l.y||0,yMax:(l.y||0)+(l.height||0)}:(l=a.graphic&&a.graphic.getBBox())?{xMin:a.plotX-l.width/2,xMax:a.plotX+l.width/2,yMin:a.plotY-l.height/2,yMax:a.plotY+l.height/2}:null}var d=a.defaultOptions,n=v.defined,q=v.error;a=v.extend;var y=v.merge,w=v.objectEach;"";var h=x.deg2rad,b=Math.max,g=Math.min;a(d,{connectors:{type:"straight",
lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});v=function(){function a(l,a,m){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(l,a,m)}a.prototype.init=function(l,a,m){this.fromPoint=l;this.toPoint=a;this.options=m;this.chart=l.series.chart;this.pathfinder=this.chart.pathfinder};a.prototype.renderPath=function(l,a,m){var f=this.chart,h=f.styledMode,b=
f.pathfinder,e=!f.options.chart.forExport&&!1!==m,c=this.graphics&&this.graphics.path;b.group||(b.group=f.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(f.seriesGroup));b.group.translate(f.plotLeft,f.plotTop);c&&c.renderer||(c=f.renderer.path().add(b.group),h||c.attr({opacity:0}));c.attr(a);l={d:l};h||(l.opacity=1);c[e?"animate":"attr"](l,m);this.graphics=this.graphics||{};this.graphics.path=c};a.prototype.addMarker=function(a,f,m){var l=this.fromPoint.series.chart,b=l.pathfinder;
l=l.renderer;var g="start"===a?this.fromPoint:this.toPoint,e=g.getPathfinderAnchorPoint(f);if(f.enabled&&((m="start"===a?m[1]:m[m.length-2])&&"M"===m[0]||"L"===m[0])){m={x:m[1],y:m[2]};m=g.getRadiansToVector(m,e);e=g.getMarkerVector(m,f.radius,e);m=-m/h;if(f.width&&f.height){var c=f.width;var t=f.height}else c=t=2*f.radius;this.graphics=this.graphics||{};e={x:e.x-c/2,y:e.y-t/2,width:c,height:t,rotation:m,rotationOriginX:e.x,rotationOriginY:e.y};this.graphics[a]?this.graphics[a].animate(e):(this.graphics[a]=
l.symbol(f.symbol).addClass("highcharts-point-connecting-path-"+a+"-marker").attr(e).add(b.group),l.styledMode||this.graphics[a].attr({fill:f.color||this.fromPoint.color,stroke:f.lineColor,"stroke-width":f.lineWidth,opacity:0}).animate({opacity:1},g.series.options.animation))}};a.prototype.getPath=function(a){var f=this.pathfinder,l=this.chart,b=f.algorithms[a.type],h=f.chartObstacles;if("function"!==typeof b)return q('"'+a.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]};b.requiresObstacles&&
!h&&(h=f.chartObstacles=f.getChartObstacles(a),l.options.connectors.algorithmMargin=a.algorithmMargin,f.chartObstacleMetrics=f.getObstacleMetrics(h));return b(this.fromPoint.getPathfinderAnchorPoint(a.startMarker),this.toPoint.getPathfinderAnchorPoint(a.endMarker),y({chartObstacles:h,lineObstacles:f.lineObstacles||[],obstacleMetrics:f.chartObstacleMetrics,hardBounds:{xMin:0,xMax:l.plotWidth,yMin:0,yMax:l.plotHeight},obstacleOptions:{margin:a.algorithmMargin},startDirectionX:f.getAlgorithmStartDirection(a.startMarker)},
a))};a.prototype.render=function(){var a=this.fromPoint,f=a.series,h=f.chart,E=h.pathfinder,p=y(h.options.connectors,f.options.connectors,a.options.connectors,this.options),d={};h.styledMode||(d.stroke=p.lineColor||a.color,d["stroke-width"]=p.lineWidth,p.dashStyle&&(d.dashstyle=p.dashStyle));d["class"]="highcharts-point-connecting-path highcharts-color-"+a.colorIndex;p=y(d,p);n(p.marker.radius)||(p.marker.radius=g(b(Math.ceil((p.algorithmMargin||8)/2)-1,1),5));a=this.getPath(p);h=a.path;a.obstacles&&
(E.lineObstacles=E.lineObstacles||[],E.lineObstacles=E.lineObstacles.concat(a.obstacles));this.renderPath(h,d,f.options.animation);this.addMarker("start",y(p.marker,p.startMarker),h);this.addMarker("end",y(p.marker,p.endMarker),h)};a.prototype.destroy=function(){this.graphics&&(w(this.graphics,function(a){a.destroy()}),delete this.graphics)};return a}();x.Connection=v;a(u.prototype,{getPathfinderAnchorPoint:function(a){var h=C(this);switch(a.align){case "right":var f="xMax";break;case "left":f="xMin"}switch(a.verticalAlign){case "top":var b=
"yMin";break;case "bottom":b="yMax"}return{x:f?h[f]:(h.xMin+h.xMax)/2,y:b?h[b]:(h.yMin+h.yMax)/2}},getRadiansToVector:function(a,h){var f;n(h)||(f=C(this))&&(h={x:(f.xMin+f.xMax)/2,y:(f.yMin+f.yMax)/2});return Math.atan2(h.y-a.y,a.x-h.x)},getMarkerVector:function(a,h,f){var b=2*Math.PI,g=C(this),l=g.xMax-g.xMin,d=g.yMax-g.yMin,e=Math.atan2(d,l),c=!1;l/=2;var t=d/2,H=g.xMin+l;g=g.yMin+t;for(var F=H,G=g,k=1,r=1;a<-Math.PI;)a+=b;for(;a>Math.PI;)a-=b;b=Math.tan(a);a>-e&&a<=e?(r=-1,c=!0):a>e&&a<=Math.PI-
e?r=-1:a>Math.PI-e||a<=-(Math.PI-e)?(k=-1,c=!0):k=-1;c?(F+=k*l,G+=r*l*b):(F+=d/(2*b)*k,G+=r*t);f.x!==H&&(F=f.x);f.y!==g&&(G=f.y);return{x:F+h*Math.cos(a),y:G-h*Math.sin(a)}}});return v});w(a,"Gantt/PathfinderAlgorithms.js",[a["Core/Utilities.js"]],function(a){function x(a,b,g){g=g||0;var h=a.length-1;b-=1e-7;for(var l,f;g<=h;)if(l=h+g>>1,f=b-a[l].xMin,0<f)g=l+1;else if(0>f)h=l-1;else return l;return 0<g?g-1:0}function u(a,b){for(var h=x(a,b.x+1)+1;h--;){var d;if(d=a[h].xMax>=b.x)d=a[h],d=b.x<=d.xMax&&
b.x>=d.xMin&&b.y<=d.yMax&&b.y>=d.yMin;if(d)return h}return-1}function v(a){var h=[];if(a.length){h.push(["M",a[0].start.x,a[0].start.y]);for(var g=0;g<a.length;++g)h.push(["L",a[g].end.x,a[g].end.y])}return h}function w(a,b){a.yMin=q(a.yMin,b.yMin);a.yMax=n(a.yMax,b.yMax);a.xMin=q(a.xMin,b.xMin);a.xMax=n(a.xMax,b.xMax)}var d=a.pick,n=Math.min,q=Math.max,y=Math.abs;a=function(a,b,g){function h(a,e,b,h,f){a={x:a.x,y:a.y};a[e]=b[h||e]+(f||0);return a}function l(a,e,b){var c=y(e[b]-a[b+"Min"])>y(e[b]-
a[b+"Max"]);return h(e,b,a,b+(c?"Max":"Min"),c?1:-1)}var f=[],m=d(g.startDirectionX,y(b.x-a.x)>y(b.y-a.y))?"x":"y",n=g.chartObstacles,p=u(n,a);g=u(n,b);if(-1<g){var q=n[g];g=l(q,b,m);q={start:g,end:b};var e=g}else e=b;-1<p&&(n=n[p],g=l(n,a,m),f.push({start:a,end:g}),g[m]>=a[m]===g[m]>=e[m]&&(m="y"===m?"x":"y",b=a[m]<b[m],f.push({start:g,end:h(g,m,n,m+(b?"Max":"Min"),b?1:-1)}),m="y"===m?"x":"y"));a=f.length?f[f.length-1].end:a;g=h(a,m,e);f.push({start:a,end:g});m=h(g,"y"===m?"x":"y",e);f.push({start:g,
end:m});f.push(q);return{path:v(f),obstacles:f}};a.requiresObstacles=!0;var I=function(a,b,g){function h(a,c,e){var b,f=a.x<c.x?1:-1;if(a.x<c.x){var t=a;var h=c}else t=c,h=a;if(a.y<c.y){var g=a;var B=c}else g=c,B=a;for(b=0>f?n(x(k,h.x),k.length-1):0;k[b]&&(0<f&&k[b].xMin<=h.x||0>f&&k[b].xMax>=t.x);){if(k[b].xMin<=h.x&&k[b].xMax>=t.x&&k[b].yMin<=B.y&&k[b].yMax>=g.y)return e?{y:a.y,x:a.x<c.x?k[b].xMin-1:k[b].xMax+1,obstacle:k[b]}:{x:a.x,y:a.y<c.y?k[b].yMin-1:k[b].yMax+1,obstacle:k[b]};b+=f}return c}
function l(a,b,c,e,f){var t=f.soft,g=f.hard,k=e?"x":"y",l={x:b.x,y:b.y},B={x:b.x,y:b.y};f=a[k+"Max"]>=t[k+"Max"];t=a[k+"Min"]<=t[k+"Min"];var z=a[k+"Max"]>=g[k+"Max"];g=a[k+"Min"]<=g[k+"Min"];var d=y(a[k+"Min"]-b[k]),m=y(a[k+"Max"]-b[k]);c=10>y(d-m)?b[k]<c[k]:m<d;B[k]=a[k+"Min"];l[k]=a[k+"Max"];a=h(b,B,e)[k]!==B[k];b=h(b,l,e)[k]!==l[k];c=a?b?c:!0:b?!1:c;c=t?f?c:!0:f?!1:c;return g?z?c:!0:z?!1:c}function f(a,b,c){if(a.x===b.x&&a.y===b.y)return[];var d=c?"x":"y",m=g.obstacleOptions.margin;var r={soft:{xMin:t,
xMax:H,yMin:F,yMax:G},hard:g.hardBounds};var z=u(k,a);if(-1<z){z=k[z];r=l(z,a,b,c,r);w(z,g.hardBounds);var B=c?{y:a.y,x:z[r?"xMax":"xMin"]+(r?1:-1)}:{x:a.x,y:z[r?"yMax":"yMin"]+(r?1:-1)};var A=u(k,B);-1<A&&(A=k[A],w(A,g.hardBounds),B[d]=r?q(z[d+"Max"]-m+1,(A[d+"Min"]+z[d+"Max"])/2):n(z[d+"Min"]+m-1,(A[d+"Max"]+z[d+"Min"])/2),a.x===B.x&&a.y===B.y?(e&&(B[d]=r?q(z[d+"Max"],A[d+"Max"])+1:n(z[d+"Min"],A[d+"Min"])-1),e=!e):e=!1);a=[{start:a,end:B}]}else d=h(a,{x:c?b.x:a.x,y:c?a.y:b.y},c),a=[{start:a,end:{x:d.x,
y:d.y}}],d[c?"x":"y"]!==b[c?"x":"y"]&&(r=l(d.obstacle,d,b,!c,r),w(d.obstacle,g.hardBounds),r={x:c?d.x:d.obstacle[r?"xMax":"xMin"]+(r?1:-1),y:c?d.obstacle[r?"yMax":"yMin"]+(r?1:-1):d.y},c=!c,a=a.concat(f({x:d.x,y:d.y},r,c)));return a=a.concat(f(a[a.length-1].end,b,!c))}function m(a,c,b){var e=n(a.xMax-c.x,c.x-a.xMin)<n(a.yMax-c.y,c.y-a.yMin);b=l(a,c,b,e,{soft:g.hardBounds,hard:g.hardBounds});return e?{y:c.y,x:a[b?"xMax":"xMin"]+(b?1:-1)}:{x:c.x,y:a[b?"yMax":"yMin"]+(b?1:-1)}}var C=d(g.startDirectionX,
y(b.x-a.x)>y(b.y-a.y)),p=C?"x":"y",D=[],e=!1,c=g.obstacleMetrics,t=n(a.x,b.x)-c.maxWidth-10,H=q(a.x,b.x)+c.maxWidth+10,F=n(a.y,b.y)-c.maxHeight-10,G=q(a.y,b.y)+c.maxHeight+10,k=g.chartObstacles;var r=x(k,t);c=x(k,H);k=k.slice(r,c+1);if(-1<(c=u(k,b))){var A=m(k[c],b,a);D.push({end:b,start:A});b=A}for(;-1<(c=u(k,b));)r=0>b[p]-a[p],A={x:b.x,y:b.y},A[p]=k[c][r?p+"Max":p+"Min"]+(r?1:-1),D.push({end:b,start:A}),b=A;a=f(a,b,C);a=a.concat(D.reverse());return{path:v(a),obstacles:a}};I.requiresObstacles=!0;
return{fastAvoid:I,straight:function(a,b){return{path:[["M",a.x,a.y],["L",b.x,b.y]],obstacles:[{start:a,end:b}]}},simpleConnect:a}});w(a,"Gantt/Pathfinder.js",[a["Gantt/Connection.js"],a["Core/Chart/Chart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"],a["Gantt/PathfinderAlgorithms.js"]],function(a,x,u,v,w,d,n){function q(a){var c=a.shapeArgs;return c?{xMin:c.x||0,xMax:(c.x||0)+(c.width||0),yMin:c.y||0,yMax:(c.y||0)+(c.height||0)}:(c=a.graphic&&a.graphic.getBBox())?
{xMin:a.plotX-c.width/2,xMax:a.plotX+c.width/2,yMin:a.plotY-c.height/2,yMax:a.plotY+c.height/2}:null}function y(a){for(var c=a.length,b=0,e,d,g=[],k=function(a,b,c){c=f(c,10);var e=a.yMax+c>b.yMin-c&&a.yMin-c<b.yMax+c,d=a.xMax+c>b.xMin-c&&a.xMin-c<b.xMax+c,g=e?a.xMin>b.xMax?a.xMin-b.xMax:b.xMin-a.xMax:Infinity,t=d?a.yMin>b.yMax?a.yMin-b.yMax:b.yMin-a.yMax:Infinity;return d&&e?c?k(a,b,Math.floor(c/2)):Infinity:p(g,t)};b<c;++b)for(e=b+1;e<c;++e)d=k(a[b],a[e]),80>d&&g.push(d);g.push(80);return J(Math.floor(g.sort(function(a,
c){return a-c})[Math.floor(g.length/10)]/2-1),1)}function C(a){if(a.options.pathfinder||a.series.reduce(function(a,b){b.options&&l(!0,b.options.connectors=b.options.connectors||{},b.options.pathfinder);return a||b.options&&b.options.pathfinder},!1))l(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),g('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}u=u.defaultOptions;var h=d.addEvent,b=d.defined,g=d.error,E=d.extend,l=d.merge,
f=d.pick,m=d.splat;"";var J=Math.max,p=Math.min;E(u,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var D=function(){function e(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}e.prototype.init=function(a){this.chart=a;this.connections=[];h(a,"redraw",function(){this.pathfinder.update()})};
e.prototype.update=function(b){var c=this.chart,f=this,e=f.connections;f.connections=[];c.series.forEach(function(b){b.visible&&!b.options.isInternal&&b.points.forEach(function(b){var e=b.options;e&&e.dependency&&(e.connect=e.dependency);var d;e=b.options&&b.options.connect&&m(b.options.connect);b.visible&&!1!==b.isInside&&e&&e.forEach(function(e){d=c.get("string"===typeof e?e:e.to);d instanceof w&&d.series.visible&&d.visible&&!1!==d.isInside&&f.connections.push(new a(b,d,"string"===typeof e?{}:e))})})});
for(var d=0,k=void 0,g=void 0,h=e.length,l=f.connections.length;d<h;++d){g=!1;for(k=0;k<l;++k)if(e[d].fromPoint===f.connections[k].fromPoint&&e[d].toPoint===f.connections[k].toPoint){f.connections[k].graphics=e[d].graphics;g=!0;break}g||e[d].destroy()}delete this.chartObstacles;delete this.lineObstacles;f.renderConnections(b)};e.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var b=function(){var b=a.chart.pathfinder;(b&&b.connections||[]).forEach(function(b){b.fromPoint&&
b.fromPoint.series===a&&b.render()});a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};!1===a.options.animation?b():a.pathfinderRemoveRenderEvent=h(a,"afterAnimate",b)}):this.connections.forEach(function(a){a.render()})};e.prototype.getChartObstacles=function(a){for(var c=[],e=this.chart.series,d=f(a.algorithmMargin,0),g,k=0,h=e.length;k<h;++k)if(e[k].visible&&!e[k].options.isInternal){var l=0,m=e[k].points.length,n=void 0;for(n=void 0;l<m;++l)n=
e[k].points[l],n.visible&&(n=q(n))&&c.push({xMin:n.xMin-d,xMax:n.xMax+d,yMin:n.yMin-d,yMax:n.yMax+d})}c=c.sort(function(a,b){return a.xMin-b.xMin});b(a.algorithmMargin)||(g=a.algorithmMargin=y(c),c.forEach(function(a){a.xMin-=g;a.xMax+=g;a.yMin-=g;a.yMax+=g}));return c};e.prototype.getObstacleMetrics=function(a){for(var b=0,c=0,e,d,f=a.length;f--;)e=a[f].xMax-a[f].xMin,d=a[f].yMax-a[f].yMin,b<e&&(b=e),c<d&&(c=d);return{maxHeight:c,maxWidth:b}};e.prototype.getAlgorithmStartDirection=function(a){var b=
"top"!==a.verticalAlign&&"bottom"!==a.verticalAlign;return"left"!==a.align&&"right"!==a.align?b?void 0:!1:b?!0:void 0};return e}();D.prototype.algorithms=n;v.Pathfinder=D;E(w.prototype,{getPathfinderAnchorPoint:function(a){var b=q(this);switch(a.align){case "right":var e="xMax";break;case "left":e="xMin"}switch(a.verticalAlign){case "top":var d="yMin";break;case "bottom":d="yMax"}return{x:e?b[e]:(b.xMin+b.xMax)/2,y:d?b[d]:(b.yMin+b.yMax)/2}},getRadiansToVector:function(a,c){var e;b(c)||(e=q(this))&&
(c={x:(e.xMin+e.xMax)/2,y:(e.yMin+e.yMax)/2});return Math.atan2(c.y-a.y,a.x-c.x)},getMarkerVector:function(a,b,d){var c=2*Math.PI,e=q(this),f=e.xMax-e.xMin,g=e.yMax-e.yMin,h=Math.atan2(g,f),l=!1;f/=2;var m=g/2,n=e.xMin+f;e=e.yMin+m;for(var p=n,t=e,u=1,v=1;a<-Math.PI;)a+=c;for(;a>Math.PI;)a-=c;c=Math.tan(a);a>-h&&a<=h?(v=-1,l=!0):a>h&&a<=Math.PI-h?v=-1:a>Math.PI-h||a<=-(Math.PI-h)?(u=-1,l=!0):u=-1;l?(p+=u*f,t+=v*f*c):(p+=g/(2*c)*u,t+=v*m);d.x!==n&&(p=d.x);d.y!==e&&(t=d.y);return{x:p+b*Math.cos(a),
y:t-b*Math.sin(a)}}});x.prototype.callbacks.push(function(a){!1!==a.options.connectors.enabled&&(C(a),this.pathfinder=new D(this),this.pathfinder.update(!0))});return D});w(a,"masters/modules/pathfinder.src.js",[],function(){})});
//# sourceMappingURL=pathfinder.js.map