/*
 Highstock JS v10.3.1 (2022-10-31)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(C){a(C);a.Highcharts=C;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function C(a,q,y,f){a.hasOwnProperty(q)||(a[q]=f.apply(null,y),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:q,module:a[q]}})))}a=a?a._modules:{};C(a,"Core/Axis/BrokenAxis.js",
[a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,q){var E=q.addEvent,f=q.find,u=q.fireEvent,B=q.isArray,w=q.isNumber,z=q.pick,r;(function(p){function e(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function r(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function t(){var g=this.brokenAxis;if(g&&g.hasBreaks){for(var c=this.tickPositions,v=this.tickPositions.info,n=[],d=0;d<c.length;d++)g.isInAnyBreak(c[d])||
n.push(c[d]);this.tickPositions=n;this.tickPositions.info=v}}function c(){this.brokenAxis||(this.brokenAxis=new F(this))}function J(){var g=this.options.connectNulls,c=this.points,v=this.xAxis,n=this.yAxis;if(this.isDirty)for(var d=c.length;d--;){var h=c[d],b=!(null===h.y&&!1===g)&&(v&&v.brokenAxis&&v.brokenAxis.isInAnyBreak(h.x,!0)||n&&n.brokenAxis&&n.brokenAxis.isInAnyBreak(h.y,!0));h.visible=b?!1:!1!==h.options.visible}}function g(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,
z(this.pointArrayMap,["y"]))}function D(g,c){var v=this,n=v.points,d,h,b,m;if(g&&g.brokenAxis&&g.brokenAxis.hasBreaks){var l=g.brokenAxis;c.forEach(function(A){d=l&&l.breakArray||[];h=g.isXAxis?g.min:z(v.options.threshold,g.min);n.forEach(function(l){m=z(l["stack"+A.toUpperCase()],l[A]);d.forEach(function(d){if(w(h)&&w(m)){b=!1;if(h<d.from&&m>d.to||h>d.from&&m<d.from)b="pointBreak";else if(h<d.from&&m>d.from&&m<d.to||h>d.from&&m>d.to&&m<d.from)b="pointInBreak";b&&u(g,b,{point:l,brk:d})}})})})}}function L(){var g=
this.currentDataGrouping,c=g&&g.gapSize;g=this.points.slice();var v=this.yAxis,n=this.options.gapSize,d=g.length-1,h;if(n&&0<d)for("value"!==this.options.gapUnit&&(n*=this.basePointRange),c&&c>n&&c>=this.basePointRange&&(n=c),h=void 0;d--;)h&&!1!==h.visible||(h=g[d+1]),c=g[d],!1!==h.visible&&!1!==c.visible&&(h.x-c.x>n&&(h=(c.x+h.x)/2,g.splice(d+1,0,{isNull:!0,x:h}),v.stacking&&this.options.stacking&&(h=v.stacking.stacks[this.stackKey][h]=new a(v,v.options.stackLabels,!1,h,this.stack),h.total=0)),
h=c);return this.getGraphPath(g)}var q=[];p.compose=function(a,p){-1===q.indexOf(a)&&(q.push(a),a.keepProps.push("brokenAxis"),E(a,"init",c),E(a,"afterInit",e),E(a,"afterSetTickPositions",t),E(a,"afterSetOptions",r));if(-1===q.indexOf(p)){q.push(p);var v=p.prototype;v.drawBreaks=D;v.gappedPath=L;E(p,"afterGeneratePoints",J);E(p,"afterRender",g)}return a};var F=function(){function g(g){this.hasBreaks=!1;this.axis=g}g.isInBreak=function(g,c){var n=g.repeat||Infinity,d=g.from,h=g.to-g.from;c=c>=d?(c-
d)%n:n-(d-c)%n;return g.inclusive?c<=h:c<h&&0!==c};g.lin2Val=function(c){var v=this.brokenAxis;v=v&&v.breakArray;if(!v||!w(c))return c;var n;for(n=0;n<v.length;n++){var d=v[n];if(d.from>=c)break;else d.to<c?c+=d.len:g.isInBreak(d,c)&&(c+=d.len)}return c};g.val2Lin=function(c){var v=this.brokenAxis;v=v&&v.breakArray;if(!v||!w(c))return c;var n=c,d;for(d=0;d<v.length;d++){var h=v[d];if(h.to<=c)n-=h.len;else if(h.from>=c)break;else if(g.isInBreak(h,c)){n-=c-h.from;break}}return n};g.prototype.findBreakAt=
function(g,c){return f(c,function(n){return n.from<g&&g<n.to})};g.prototype.isInAnyBreak=function(c,v){var n=this.axis,d=n.options.breaks||[],h=d.length,b;if(h&&w(c)){for(;h--;)if(g.isInBreak(d[h],c)){var m=!0;b||(b=z(d[h].showPoints,!n.isXAxis))}var l=m&&v?m&&!b:m}return l};g.prototype.setBreaks=function(c,v){var n=this,d=n.axis,h=B(c)&&!!c.length;d.isDirty=n.hasBreaks!==h;n.hasBreaks=h;d.options.breaks=d.userOptions.breaks=c;d.forceRedraw=!0;d.series.forEach(function(b){b.isDirty=!0});h||d.val2lin!==
g.val2Lin||(delete d.val2lin,delete d.lin2val);h&&(d.userOptions.ordinal=!1,d.lin2val=g.lin2Val,d.val2lin=g.val2Lin,d.setExtremes=function(b,m,l,A,h){if(n.hasBreaks){for(var M=this.options.breaks||[],g;g=n.findBreakAt(b,M);)b=g.to;for(;g=n.findBreakAt(m,M);)m=g.from;m<b&&(m=b)}d.constructor.prototype.setExtremes.call(this,b,m,l,A,h)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);n.unitLength=void 0;if(n.hasBreaks){var b=d.options.breaks||[],m=[],l=[],A=z(d.pointRangePadding,
0),h=0,c,K=d.userMin||d.min,H=d.userMax||d.max,v;b.forEach(function(b){c=b.repeat||Infinity;w(K)&&w(H)&&(g.isInBreak(b,K)&&(K+=b.to%c-K%c),g.isInBreak(b,H)&&(H-=H%c-b.from%c))});b.forEach(function(b){I=b.from;c=b.repeat||Infinity;if(w(K)&&w(H)){for(;I-c>K;)I-=c;for(;I<K;)I+=c;for(v=I;v<H;v+=c)m.push({value:v,move:"in"}),m.push({value:v+b.to-b.from,move:"out",size:b.breakSize})}});m.sort(function(b,m){return b.value===m.value?("in"===b.move?0:1)-("in"===m.move?0:1):b.value-m.value});var a=0;var I=
K;m.forEach(function(b){a+="in"===b.move?1:-1;1===a&&"in"===b.move&&(I=b.value);0===a&&w(I)&&(l.push({from:I,to:b.value,len:b.value-I-(b.size||0)}),h+=b.value-I-(b.size||0))});n.breakArray=l;w(K)&&w(H)&&w(d.min)&&(n.unitLength=H-K-h+A,u(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:n.unitLength&&(d.transA*=(H-d.min+A)/n.unitLength),A&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=K,d.max=H)}});z(v,!0)&&d.chart.redraw()};return g}();p.Additions=F})(r||(r={}));return r});C(a,"masters/modules/broken-axis.src.js",
[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,q){q.compose(a.Axis,a.Series)});C(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});C(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var e=a.length;a=f(a);r(a)&&e&&(a=w(a/e));return a}function f(a){var e=a.length;if(!e&&a.hasNulls)var p=null;else if(e)for(p=0;e--;)p+=a[e];return p}var u=q.arrayMax,
B=q.arrayMin,w=q.correctFloat,z=q.extend,r=q.isNumber;q={average:E,averages:function(){var a=[];[].forEach.call(arguments,function(e){a.push(E(e))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?u(a):a.hasNulls?null:void 0},hlc:function(p,e,k){p=a.high(p);e=a.low(e);k=a.close(k);if(r(p)||r(e)||r(k))return[p,e,k]},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},ohlc:function(p,e,k,t){p=
a.open(p);e=a.high(e);k=a.low(k);t=a.close(t);if(r(p)||r(e)||r(k)||r(t))return[p,e,k,t]},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},range:function(p,e){p=a.low(p);e=a.high(e);if(r(p)||r(e))return[p,e];if(null===p&&null===e)return null},sum:f};z(a,q);return q});C(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},
hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});C(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var c=this,e=c.series;e.forEach(function(g){g.groupPixelWidth=void 0});e.forEach(function(g){g.groupPixelWidth=
c.getGroupPixelWidth&&c.getGroupPixelWidth();g.groupPixelWidth&&(g.hasProcessed=!0);g.applyGrouping(!!a.hasExtremesChanged)})}function f(){for(var e=this.series,c=e.length,r=0,g=!1,D,k;c--;)if(k=e[c].options.dataGrouping)if(r=Math.max(r,p(k.groupPixelWidth,a.common.groupPixelWidth)),D=(e[c].processedXData||e[c].data).length,e[c].groupPixelWidth||D>this.chart.plotSizeX/r||D&&k.forced)g=!0;return g?r:0}function u(){this.series.forEach(function(a){a.hasProcessed=!1})}function B(a,c){var e;c=p(c,!0);
a||(a={forced:!1,units:null});if(this instanceof k)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(g){g.dataGrouping="boolean"===typeof a?a:r(a,g.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()}var w=q.addEvent,z=q.extend,r=q.merge,p=q.pick,e=[],k;return{compose:function(a){k=a;-1===e.indexOf(a)&&(e.push(a),w(a,"afterSetScale",u),w(a,"postProcessData",E),z(a.prototype,{applyGrouping:E,getGroupPixelWidth:f,
setDataGrouping:B}))}}});C(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,f,u,B){function w(a){var c=this.chart,d=this.options.dataGrouping,h=!1!==this.allowDG&&d&&F(d.enabled,c.options.isStock),b=this.visible||!c.options.chart.ignoreHiddenSeries,m=this.currentDataGrouping,
l=!1;h&&!this.requireSorting&&(this.requireSorting=l=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!h;l&&(this.requireSorting=!1);if(!a){this.destroyGroupedData();var A=d.groupAll?this.xData:this.processedXData,M=d.groupAll?this.yData:this.processedYData;h=c.plotSizeX;a=this.xAxis;var N=a.options.ordinal,K=this.groupPixelWidth;l=void 0;if(K&&A&&A.length){this.isDirty=l=!0;this.points=null;var H=a.getExtremes();var e=H.min;H=H.max;N=N&&a.ordinal&&a.ordinal.getGroupIntervalFactor(e,
H,this)||1;h=a.getTimeTicks(y.Additions.prototype.normalizeTimeTickInterval(K*(H-e)/h*N,d.units||q.units),Math.min(e,A[0]),Math.max(H,A[A.length-1]),a.options.startOfWeek,A,this.closestPointRange);K=t.groupData.apply(this,[A,M,h,d.approximation]);A=K.groupedXData;M=K.groupedYData;N=0;d&&d.smoothed&&A.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",g(32,!1,c,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));c=A;var D=this.options.dataGrouping;e=this.currentDataGrouping&&
this.currentDataGrouping.gapSize;if(D&&this.xData&&e&&this.groupMap){var I=c.length-1;var r=D.anchor;var v=F(D.firstAnchor,r);D=F(D.lastAnchor,r);if(r&&"start"!==r){var k=e*{middle:.5,end:1}[r];for(r=c.length-1;r--&&0<r;)c[r]+=k}if(v&&"start"!==v&&this.xData[0]>=c[0]){r=this.groupMap[0].start;k=this.groupMap[0].length;var p=void 0;L(r)&&L(k)&&(p=r+(k-1));c[0]={middle:c[0]+.5*e,end:c[0]+e,firstPoint:this.xData[0],lastPoint:p&&this.xData[p]}[v]}D&&"start"!==D&&e&&c[I]>=H-e&&(H=this.groupMap[this.groupMap.length-
1].start,c[I]={middle:c[I]+.5*e,end:c[I]+e,firstPoint:H&&this.xData[H],lastPoint:this.xData[this.xData.length-1]}[D])}for(H=1;H<h.length;H++)h.info.segmentStarts&&-1!==h.info.segmentStarts.indexOf(H)||(N=Math.max(h[H]-h[H-1],N));H=h.info;H.gapSize=N;this.closestPointRange=h.info.totalRange;this.groupMap=K.groupMap;if(b){b=A;if(J(b[0])&&L(a.min)&&L(a.dataMin)&&b[0]<a.min){if(!J(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(b[0],a.min);a.dataMin=Math.min(b[0],a.dataMin)}if(J(b[b.length-
1])&&L(a.max)&&L(a.dataMax)&&b[b.length-1]>a.max){if(!J(a.options.max)&&L(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(b[b.length-1],a.max);a.dataMax=Math.max(b[b.length-1],a.dataMax)}}d.groupAll&&(this.allGroupedData=M,d=this.cropData(A,M,a.min,a.max,1),A=d.xData,M=d.yData,this.cropStart=d.start);this.processedXData=A;this.processedYData=M}else this.groupMap=null;this.hasGroupedData=l;this.currentDataGrouping=H;this.preventGraphAnimation=(m&&m.totalRange)!==(H&&H.totalRange)}}function z(){this.groupedData&&
(this.groupedData.forEach(function(a,g){a&&(this.groupedData[g]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function r(){x.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function p(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function e(g,c,d,h){var b=this,m=b.data,l=b.options&&b.options.data,A=[],M=[],N=[],K=g.length,H=!!c,n=[],e=b.pointArrayMap,I=e&&e.length,r=["x"].concat(e||
["y"]),D=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,v=0;h="function"===typeof h?h:h&&a[h]?a[h]:a[b.getDGApproximation&&b.getDGApproximation()||"average"];if(I)for(var p=e.length;p--;)n.push([]);else n.push([]);p=I||1;for(var t=0;t<=K;t++)if(!(g[t]<d[0])){for(;"undefined"!==typeof d[k+1]&&g[t]>=d[k+1]||t===K;){var x=d[k];b.dataGroupInfo={start:D?v:b.cropStart+v,length:n[0].length};var w=h.apply(b,n);b.pointClass&&!J(b.dataGroupInfo.options)&&(b.dataGroupInfo.options=E(b.pointClass.prototype.optionsToObject.call({series:b},
b.options.data[b.cropStart+v])),r.forEach(function(m){delete b.dataGroupInfo.options[m]}));"undefined"!==typeof w&&(A.push(x),M.push(w),N.push(b.dataGroupInfo));v=t;for(x=0;x<p;x++)n[x].length=0,n[x].hasNulls=!1;k+=1;if(t===K)break}if(t===K)break;if(e){x=b.options.dataGrouping&&b.options.dataGrouping.groupAll?t:b.cropStart+t;w=m&&m[x]||b.pointClass.prototype.applyOptions.apply({series:b},[l[x]]);var f=void 0;for(x=0;x<I;x++)f=w[e[x]],L(f)?n[x].push(f):null===f&&(n[x].hasNulls=!0)}else x=H?c[t]:null,
L(x)?n[0].push(x):null===x&&(n[0].hasNulls=!0)}return{groupedXData:A,groupedYData:M,groupMap:N}}function k(a){a=a.options;var g=this.type,d=this.chart.options.plotOptions,h=this.useCommonDataGrouping&&q.common,b=q.seriesSpecific,m=f.defaultOptions.plotOptions[g].dataGrouping;if(d&&(b[g]||h)){var l=this.chart.rangeSelector;m||(m=E(q.common,b[g]));a.dataGrouping=E(h,m,d.series&&d.series.dataGrouping,d[g].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&l&&L(l.selected)&&l.buttonOptions[l.selected].dataGrouping)}}
var t=u.series.prototype,c=B.addEvent,J=B.defined,g=B.error,D=B.extend,L=B.isNumber,E=B.merge,F=B.pick,x=t.generatePoints,G=[];return{compose:function(a){var n=a.prototype.pointClass;-1===G.indexOf(n)&&(G.push(n),c(n,"update",function(){if(this.dataGroup)return g(24,!1,this.series.chart),!1}));-1===G.indexOf(a)&&(G.push(a),c(a,"afterSetOptions",k),c(a,"destroy",z),D(a.prototype,{applyGrouping:w,destroyGroupedData:z,generatePoints:r,getDGApproximation:p,groupData:e}))},groupData:e}});C(a,"Extensions/DataGrouping/DataGrouping.js",
[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,q,y,f,u){function B(a){var e=this.chart,c=e.time,k=a.labelConfig,g=k.series,D=g.tooltipOptions,L=g.options.dataGrouping,f=g.xAxis,F=D.xDateFormat,x=D[a.isFooter?"footerFormat":"headerFormat"];if(f&&"datetime"===f.options.type&&L&&p(k.key)){var u=g.currentDataGrouping;
L=L.dateTimeLabelFormats||q.common.dateTimeLabelFormats;if(u)if(D=L[u.unitName],1===u.count)F=D[0];else{F=D[1];var v=D[2]}else!F&&L&&f.dateTime&&(F=f.dateTime.getXDateFormat(k.x,D.dateTimeLabelFormats));F=c.dateFormat(F,k.key);v&&(F+=c.dateFormat(v,k.key+u.totalRange-1));g.chart.styledMode&&(x=this.styledModeFormat(x));a.text=w(x,{point:r(k.point,{key:F}),series:g},e);a.preventDefault()}}var w=f.format,z=u.addEvent,r=u.extend,p=u.isNumber,e=[];f={compose:function(r,p,c){a.compose(r);y.compose(p);
-1===e.indexOf(c)&&(e.push(c),z(c,"headerFormatter",B))},groupData:y.groupData};"";"";return f});C(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,q,y,f){a.dataGrouping={approximationDefaults:q,approximations:y};f.compose(a.Axis,a.Series,a.Tooltip)});C(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y,f){var u=q.prototype.tooltipFormatter,B=f.addEvent,w=f.arrayMax,z=f.arrayMin,r=f.correctFloat,p=f.defined,e=f.isArray,k=f.isNumber,t=f.isString,c=f.pick,J;(function(a){function g(b,l,d){this.isXAxis||(this.series.forEach(function(m){"compare"===b&&"boolean"!==typeof l?m.setCompare(l,!1):"cumulative"!==b||t(l)||m.setCumulative(l,!1)}),c(d,!0)&&this.chart.redraw())}function L(b){var m=this,d=m.series.chart.numberFormatter,h=function(l){b=
b.replace("{point."+l+"}",(0<m[l]&&"change"===l?"+":"")+d(m[l],c(m.series.tooltipOptions.changeDecimals,2)))};p(m.change)&&h("change");p(m.cumulativeSum)&&h("cumulativeSum");return u.apply(this,[b])}function J(){var m=this.options.compare;if("percent"===m||"value"===m||this.options.cumulative){var l=new b(this);"percent"===m||"value"===m?l.initCompare(m):l.initCumulative()}this.dataModify=l}function f(m){m=m.dataExtremes;var l=m.activeYData;if(this.dataModify&&m){var d=void 0;this.options.compare?
d=[this.dataModify.modifyValue(m.dataMin),this.dataModify.modifyValue(m.dataMax)]:this.options.cumulative&&e(l)&&2<=l.length&&(d=b.getCumulativeExtremes(l));d&&(m.dataMin=z(d),m.dataMax=w(d))}}function x(b,l){this.options.compare=this.userOptions.compare=b;this.update({},c(l,!0));!this.dataModify||"value"!==b&&"percent"!==b?this.points.forEach(function(b){delete b.change}):this.dataModify.initCompare(b)}function q(){if(this.xAxis&&this.processedYData&&this.dataModify){var b=this.processedXData,l=
this.processedYData,d=l.length,h=!0===this.options.compareStart?0:1,a=-1,g;this.pointArrayMap&&(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(g=0;g<d-h;g++){var c=l[g]&&-1<a?l[g][a]:l[g];if(k(c)&&0!==c&&b[g+h]>=(this.xAxis.min||0)){this.dataModify.compareValue=c;break}}}}function v(b,l){this.setModifier("compare",b,l)}function n(b,l){b=c(b,!1);this.options.cumulative=this.userOptions.cumulative=b;this.update({},c(l,!0));this.dataModify?this.dataModify.initCumulative():
this.points.forEach(function(b){delete b.cumulativeSum})}function d(b,l){this.setModifier("cumulative",b,l)}var h=[];a.compose=function(b,l,A){if(-1===h.indexOf(b)){h.push(b);var m=b.prototype;m.setCompare=x;m.setCumulative=n;B(b,"afterInit",J);B(b,"afterGetExtremes",f);B(b,"afterProcessData",q)}-1===h.indexOf(l)&&(h.push(l),l=l.prototype,l.setCompare=v,l.setModifier=g,l.setCumulative=d);-1===h.indexOf(A)&&(h.push(A),A.prototype.tooltipFormatter=L);return b};var b=function(){function b(b){this.series=
b}b.prototype.modifyValue=function(){return 0};b.getCumulativeExtremes=function(b){var m=Infinity,l=-Infinity;b.reduce(function(b,d){d=b+d;m=Math.min(m,d,b);l=Math.max(l,d,b);return d});return[m,l]};b.prototype.initCompare=function(b){this.modifyValue=function(m,l){null===m&&(m=0);var d=this.compareValue;return"undefined"!==typeof m&&"undefined"!==typeof d?(m="value"===b?m-d:m/d*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof l&&(l=this.series.points[l])&&(l.change=m),m):0}};
b.prototype.initCumulative=function(){this.modifyValue=function(b,m){null===b&&(b=0);if(void 0!==b&&void 0!==m){var l=0<m?this.series.points[m-1]:null;l&&l.cumulativeSum&&(b=r(l.cumulativeSum+b));if(m=this.series.points[m])m.cumulativeSum=b;return b}return 0}};return b}();a.Additions=b})(J||(J={}));"";return J});C(a,"Core/Axis/NavigatorAxisComposition.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){function E(){this.navigatorAxis||(this.navigatorAxis=new k(this))}function f(a){var c=
this.chart.options,e=c.navigator,g=this.navigatorAxis,r=c.chart.zooming.pinchType,k=c.rangeSelector;c=c.chart.zooming.type;this.isXAxis&&(e&&e.enabled||k&&k.enabled)&&("y"===c?a.zoomed=!1:(!u&&"xy"===c||u&&"xy"===r)&&this.options.range&&(e=g.previousZoom,z(a.newMin)?g.previousZoom=[this.min,this.max]:e&&(a.newMin=e[0],a.newMax=e[1],g.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}var u=a.isTouchDevice,B=q.addEvent,w=q.correctFloat,z=q.defined,r=q.isNumber,p=q.pick,e=[],k=
function(){function a(a){this.axis=a}a.compose=function(a){-1===e.indexOf(a)&&(e.push(a),a.keepProps.push("navigatorAxis"),B(a,"init",E),B(a,"zoom",f))};a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,e,g,D){var c=this.axis,k=c.chart;a=p(g,c.translate(a,!0,!c.horiz));e=p(D,c.translate(e,!0,!c.horiz));k=k&&k.fixedRange;c=(c.pointRange||0)/2;var t=k&&(e-a)/k;z(g)||(a=w(a+c));z(D)||(e=w(e-c));.7<t&&1.3>t&&(D?a=e-k:e=a+k);r(a)&&r(e)||(a=e=void 0);return{min:a,max:e}};
return a}();return k});C(a,"Stock/Navigator/NavigatorDefaults.js",[a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"]],function(a,q){a=a.parse;q=q.seriesTypes;q={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:a("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:"undefined"===typeof q.areaspline?"line":"areaspline",fillOpacity:.05,
lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},
threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return q});C(a,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(a,
q,y,f,u){void 0===u&&(u={});a=u.width?u.width/2:y;q=Math.round(a/3)+.5;f=u.height||f;return[["M",-a-1,.5],["L",a,.5],["L",a,f+.5],["L",-a-1,f+.5],["L",-a-1,.5],["M",-q,4],["L",-q,f-3],["M",q-1,4],["L",q-1,f-3]]}}});C(a,"Stock/Navigator/NavigatorComposition.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/Navigator/NavigatorSymbols.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Utilities.js"]],function(a,
q,y,f,u,B,w){function z(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function r(){var d=this.legend,b=this.navigator;if(b){var m=d&&d.options;var l=b.xAxis;var a=b.yAxis;var g=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-g-b.height:this.spacing[3]+g,b.top=this.plotTop+g):(b.left=v(l.left,this.plotLeft+g),b.top=b.navigatorOptions.top||this.chartHeight-b.height-g-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(m&&"bottom"===
m.verticalAlign&&"proximate"!==m.layout&&m.enabled&&!m.floating?d.legendHeight+v(m.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));l&&a&&(this.inverted?l.options.left=a.options.left=b.left:l.options.top=a.options.top=b.top,l.setAxisSize(),a.setAxisSize())}}function p(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new d(this),v(a.redraw,!0)&&this.redraw(a.animation))}function e(){var a=this.options;if(a.navigator.enabled||
a.scrollbar.enabled)this.scroller=this.navigator=new d(this)}function k(){var d=this.options,b=d.navigator,m=d.rangeSelector;if((b&&b.enabled||m&&m.enabled)&&(!L&&"x"===d.chart.zooming.type||L&&"x"===d.chart.zooming.pinchType))return!1}function t(d){var b=d.navigator;b&&d.xAxis[0]&&(d=d.xAxis[0].getExtremes(),b.render(d.min,d.max))}function c(d){var b=d.options.navigator||{},m=d.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!m.enabled||(G(!0,this.options.navigator,b),G(!0,this.options.scrollbar,
m),delete d.options.navigator,delete d.options.scrollbar)}function J(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}var g=a.defaultOptions,D=a.setOptions,L=q.isTouchDevice,E=B.getRendererType,F=w.addEvent,x=w.extend,G=w.merge,v=w.pick,n=[],d;return{compose:function(a,b,m,l){y.compose(a);d=m;-1===n.indexOf(b)&&(n.push(b),b.prototype.callbacks.push(t),F(b,"afterAddSeries",z),F(b,"afterSetChartSize",r),F(b,"afterUpdate",p),F(b,"beforeRender",e),F(b,"beforeShowResetZoom",
k),F(b,"update",c));-1===n.indexOf(l)&&(n.push(l),F(l,"afterUpdate",J));-1===n.indexOf(E)&&(n.push(E),x(E().prototype.symbols,u));-1===n.indexOf(D)&&(n.push(D),x(g,{navigator:f}))}}});C(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var q=a.addEvent,y=a.defined,f=a.pick;return function(){function a(){}a.compose=function(u,w){if(-1===a.composed.indexOf(u))a.composed.push(u);else return u;var z=function(a){var r=f(a.options&&a.options.min,a.min),e=f(a.options&&a.options.max,a.max);
return{axisMin:r,axisMax:e,scrollMin:y(a.dataMin)?Math.min(r,a.min,a.dataMin,f(a.threshold,Infinity)):r,scrollMax:y(a.dataMax)?Math.max(e,a.max,a.dataMax,f(a.threshold,-Infinity)):e}};q(u,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new w(a.chart.renderer,a.options.scrollbar,a.chart),q(a.scrollbar,"changed",function(r){var e=z(a),k=e.axisMax,p=e.scrollMin,
c=e.scrollMax-p;y(e.axisMin)&&y(k)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(e=p+c*this.to,p+=c*this.from):(e=p+c*(1-this.from),p+=c*(1-this.to)),this.shouldUpdateExtremes(r.DOMType)?a.setExtremes(p,e,!0,"mousemove"!==r.DOMType&&"touchmove"!==r.DOMType,r):this.setRange(this.from,this.to))}))});q(u,"afterRender",function(){var a=z(this),p=a.scrollMin,e=a.scrollMax;a=this.scrollbar;var k=this.axisTitleMargin+(this.titleOffset||0),t=this.chart.scrollbarsOffsets,c=this.options.margin||0;a&&(this.horiz?
(this.opposite||(t[1]+=k),a.position(this.left,this.top+this.height+2+t[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(t[1]+=c),k=1):(this.opposite&&(t[0]+=k),a.position(a.options.opposite?this.left+this.width+2+t[0]-(this.opposite?0:c):this.opposite?0:c,this.top,this.width,this.height),this.opposite&&(t[0]+=c),k=0),t[k]+=a.size+a.options.margin,isNaN(p)||isNaN(e)||!y(this.min)||!y(this.max)||this.min===this.max?a.setRange(0,1):(t=(this.min-p)/(e-p),p=(this.max-p)/(e-p),this.horiz&&
!this.reversed||!this.horiz&&this.reversed?a.setRange(t,p):a.setRange(1-p,1-t)))});q(u,"afterGetOffset",function(){var a=this.scrollbar&&!this.scrollbar.options.opposite;a=this.horiz?2:a?3:1;var p=this.scrollbar;p&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=p.size+p.options.margin)});return u};a.composed=[];return a}()});C(a,"Stock/Scrollbar/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});C(a,"Stock/Scrollbar/Scrollbar.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Utilities.js"]],
function(a,q,y,f,u){var B=a.defaultOptions,w=u.addEvent,z=u.correctFloat,r=u.defined,p=u.destroyObjectProperties,e=u.fireEvent,k=u.merge,t=u.pick,c=u.removeEvent;a=function(){function a(a,c,e){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=
void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,c,e)}a.compose=function(g){y.compose(g,a)};a.swapXY=function(a,c){c&&a.forEach(function(a){for(var g=a.length,c,e=0;e<g;e+=2)c=a[e+1],"number"===typeof c&&(a[e+1]=a[e+2],a[e+2]=c)});return a};a.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,e=this.scrollbarGroup.element,k=this.track.element,p=this.mouseDownHandler.bind(this),x=this.mouseMoveHandler.bind(this),r=this.mouseUpHandler.bind(this);
a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[k,"click",this.trackClick.bind(this)],[e,"mousedown",p],[e.ownerDocument,"mousemove",x],[e.ownerDocument,"mouseup",r]];q.hasTouch&&a.push([e,"touchstart",p],[e.ownerDocument,"touchmove",x],[e.ownerDocument,"touchend",r]);a.forEach(function(a){w.apply(null,a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var g=(this.to-this.from)*t(this.options.step,.2);this.updatePosition(this.from+
g,this.to+g);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var g=z(this.to-this.from)*t(this.options.step,.2);this.updatePosition(z(this.from-g),z(this.to-g));e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var g=this.options;g=g.minWidth>this.calculatedWidth?g.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-g),chartY:(a.chartY-
this.y-this.yOffset)/(this.barWidth-g)}};a.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(g){a[g]&&a[g].destroy&&(a[g]=a[g].destroy())});c&&a===c.scrollbar&&(c.scrollbar=null,p(c.scrollbarButtons))};a.prototype.drawScrollbarButton=function(g){var c=this.renderer,e=this.scrollbarButtons,k=this.options,p=this.size,x=c.g().add(this.group);e.push(x);x=c.rect().addClass("highcharts-scrollbar-button").add(x);
this.chart.styledMode||x.attr({stroke:k.buttonBorderColor,"stroke-width":k.buttonBorderWidth,fill:k.buttonBackgroundColor});x.attr(x.crisp({x:-.5,y:-.5,width:p+1,height:p+1,r:k.buttonBorderRadius},x.strokeWidth()));x=c.path(a.swapXY([["M",p/2+(g?-1:1),p/2-3],["L",p/2+(g?-1:1),p/2+3],["L",p/2+(g?2:-2),p/2]],k.vertical)).addClass("highcharts-scrollbar-arrow").add(e[g]);this.chart.styledMode||x.attr({fill:k.buttonArrowColor})};a.prototype.init=function(a,c,e){this.scrollbarButtons=[];this.renderer=a;
this.userOptions=c;this.options=k(f,B.scrollbar,c);this.chart=e;this.size=t(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var c=this.chart.pointer.normalize(a),g=this.options.vertical?"chartY":"chartX",k=this.initPositions||
[];!this.grabbedCenter||a.touches&&0===a.touches[0][g]||(c=this.cursorToScrollbarPosition(c)[g],g=this[g],g=c-g,this.hasDragged=!0,this.updatePosition(k[0]+g,k[1]+g),this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=
function(a,c,e,k){var g=this.options.vertical,p=this.rendered?"animate":"attr",r=k,v=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=e;this.height=k;this.xOffset=r;this.yOffset=v;g?(this.width=this.yOffset=e=v=this.size,this.xOffset=r=0,this.barWidth=k-2*e,this.x=a+=this.options.margin):(this.height=this.xOffset=k=r=this.size,this.barWidth=e-2*k,this.y+=this.options.margin);this.group[p]({translateX:a,translateY:this.y});this.track[p]({width:e,height:k});this.scrollbarButtons[1][p]({translateX:g?
0:e-r,translateY:g?k-v:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){c.apply(null,a)});this._events.length=0};a.prototype.render=function(){var c=this.renderer,e=this.options,k=this.size,p=this.chart.styledMode,r=c.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=r;this.track=c.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:e.trackBorderRadius||0,height:k,width:k}).add(r);p||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,
"stroke-width":e.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=c.g().add(r);this.scrollbar=c.rect().addClass("highcharts-scrollbar-thumb").attr({height:k,width:k,r:e.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=c.path(a.swapXY([["M",-3,k/4],["L",-3,2*k/3],["M",0,k/4],["L",0,2*k/3],["M",3,k/4],["L",3,2*k/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);p||(this.scrollbar.attr({fill:e.barBackgroundColor,
stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,c){var e=this.options,g=e.vertical,k=e.minWidth,p=this.barWidth,t=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?
"attr":"animate";if(r(p)){var v=p*Math.min(c,1);a=Math.max(a,0);var n=Math.ceil(p*a);this.calculatedWidth=v=z(v-n);v<k&&(n=(p-k+v)*a,v=k);k=Math.floor(n+this.xOffset+this.yOffset);p=v/2-.5;this.from=a;this.to=c;g?(this.scrollbarGroup[t]({translateY:k}),this.scrollbar[t]({height:v}),this.scrollbarRifles[t]({translateY:p}),this.scrollbarTop=k,this.scrollbarLeft=0):(this.scrollbarGroup[t]({translateX:k}),this.scrollbar[t]({width:v}),this.scrollbarRifles[t]({translateX:p}),this.scrollbarLeft=k,this.scrollbarTop=
0);12>=v?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===e.showFull&&(0>=a&&1<=c?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return t(this.options.liveRedraw,q.svg&&!q.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!r(a)};a.prototype.trackClick=function(a){var c=this.chart.pointer.normalize(a),g=this.to-this.from,k=this.y+this.scrollbarTop,p=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>k||!this.options.vertical&&
c.chartX>p?this.updatePosition(this.from+g,this.to+g):this.updatePosition(this.from-g,this.to-g);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,k(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,c){1<c&&(a=z(1-z(c-a)),c=1);0>a&&(c=z(c-a),a=0);this.from=a;this.to=c};a.defaultOptions=f;return a}();B.scrollbar=k(!0,a.defaultOptions,B.scrollbar);return a});C(a,"Stock/Navigator/Navigator.js",
[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorComposition.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Utilities.js"]],function(a,q,y,f,u,B,w){function z(a){for(var b=[],m=1;m<arguments.length;m++)b[m-1]=arguments[m];b=[].filter.call(b,x);if(b.length)return Math[a].apply(0,b)}var r=q.defaultOptions,p=y.hasTouch,e=y.isTouchDevice,k=w.addEvent,t=w.clamp,c=w.correctFloat,J=w.defined,g=w.destroyObjectProperties,
D=w.erase,E=w.extend,C=w.find,F=w.isArray,x=w.isNumber,G=w.merge,v=w.pick,n=w.removeEvent,d=w.splat;return function(){function h(b){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(b)}h.compose=function(b,a,l){u.compose(b,
a,h,l)};h.prototype.drawHandle=function(b,a,l,d){var m=this.navigatorOptions.handles.height;this.handles[a][d](l?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-m)}:{translateX:Math.round(this.left+parseInt(b,10)),translateY:Math.round(this.top+this.height/2-m/2-1)})};h.prototype.drawOutline=function(b,a,l,d){var m=this.navigatorOptions.maskInside,h=this.outline.strokeWidth(),A=h/2,c=h%2/2;h=this.outlineHeight;var e=this.scrollbarHeight||0,g=this.size,
n=this.left-e,k=this.top;l?(n-=A,l=k+a+c,a=k+b+c,c=[["M",n+h,k-e-c],["L",n+h,l],["L",n,l],["L",n,a],["L",n+h,a],["L",n+h,k+g+e]],m&&c.push(["M",n+h,l-A],["L",n+h,a+A])):(b+=n+e-c,a+=n+e-c,k+=A,c=[["M",n,k],["L",b,k],["L",b,k+h],["L",a,k+h],["L",a,k],["L",n+g+2*e,k]],m&&c.push(["M",b-A,k],["L",a+A,k]));this.outline[d]({d:c})};h.prototype.drawMasks=function(b,a,l,d){var m=this.left,h=this.top,A=this.height;if(l){var c=[m,m,m];var e=[h,h+b,h+a];var g=[A,A,A];var n=[b,a-b,this.size-a]}else c=[m,m+b,m+
a],e=[h,h,h],g=[b,a-b,this.size-a],n=[A,A,A];this.shades.forEach(function(b,a){b[d]({x:c[a],y:e[a],width:g[a],height:n[a]})})};h.prototype.renderElements=function(){var b=this,a=b.navigatorOptions,d=a.maskInside,h=b.chart,c=h.renderer,e={cursor:h.inverted?"ns-resize":"ew-resize"},g=b.navigatorGroup=c.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!d,d,!d].forEach(function(m,d){var l=c.rect().addClass("highcharts-navigator-mask"+(1===d?"-inside":"-outside")).add(g);h.styledMode||(l.attr({fill:m?
a.maskFill:"rgba(0,0,0,0)"}),1===d&&l.css(e));b.shades[d]=l});b.outline=c.path().addClass("highcharts-navigator-outline").add(g);h.styledMode||b.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor});if(a.handles&&a.handles.enabled){var n=a.handles;[0,1].forEach(function(m){n.inverted=!!h.inverted;b.handles[m]=c.symbol(n.symbols[m],-n.width/2-1,0,n.width,n.height,a.handles);b.handles[m].attr({zIndex:7-m}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][m]).add(g);
h.styledMode||b.handles[m].attr({fill:n.backgroundColor,stroke:n.borderColor,"stroke-width":n.lineWidth}).css(e)})}};h.prototype.update=function(b){(this.series||[]).forEach(function(b){b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();G(!0,this.chart.options.navigator,b);this.init(this.chart)};h.prototype.render=function(b,a,d,h){var m=this.chart,l=this.xAxis,A=l.pointRange||0,e=l.navigatorAxis.fake?m.xAxis[0]:l,g=this.navigatorEnabled,n=this.rendered,k=m.inverted,p=m.xAxis[0].minRange,
r=m.xAxis[0].options.maxRange,f=this.scrollbarHeight,w;if(!this.hasDragged||J(d)){b=c(b-A/2);a=c(a+A/2);if(!x(b)||!x(a))if(n)d=0,h=v(l.width,e.width);else return;this.left=v(l.left,m.plotLeft+f+(k?m.plotWidth:0));var u=this.size=w=v(l.len,(k?m.plotHeight:m.plotWidth)-2*f);m=k?f:w+2*f;d=v(d,l.toPixels(b,!0));h=v(h,l.toPixels(a,!0));x(d)&&Infinity!==Math.abs(d)||(d=0,h=m);b=l.toValue(d,!0);a=l.toValue(h,!0);var q=Math.abs(c(a-b));q<p?this.grabbedLeft?d=l.toPixels(a-p-A,!0):this.grabbedRight&&(h=l.toPixels(b+
p+A,!0)):J(r)&&c(q-A)>r&&(this.grabbedLeft?d=l.toPixels(a-r-A,!0):this.grabbedRight&&(h=l.toPixels(b+r+A,!0)));this.zoomedMax=t(Math.max(d,h),0,u);this.zoomedMin=t(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,h),0,u);this.range=this.zoomedMax-this.zoomedMin;u=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);g&&(this.navigatorGroup.attr({visibility:"inherit"}),n=n&&!this.hasDragged?"animate":"attr",this.drawMasks(d,u,k,n),this.drawOutline(d,u,k,n),this.navigatorOptions.handles.enabled&&
(this.drawHandle(d,0,k,n),this.drawHandle(u,1,k,n)));this.scrollbar&&(k?(k=this.top-f,e=this.left-f+(g||!e.opposite?0:(e.titleOffset||0)+e.axisTitleMargin),f=w+2*f):(k=this.top+(g?this.height:-f),e=this.left-f),this.scrollbar.position(e,k,m,f),this.scrollbar.setRange(this.zoomedMin/(w||1),this.zoomedMax/(w||1)));this.rendered=!0}};h.prototype.addMouseEvents=function(){var b=this,a=b.chart,d=a.container,h=[],c,e;b.mouseMoveHandler=c=function(a){b.onMouseMove(a)};b.mouseUpHandler=e=function(a){b.onMouseUp(a)};
h=b.getPartsEvents("mousedown");h.push(k(a.renderTo,"mousemove",c),k(d.ownerDocument,"mouseup",e));p&&(h.push(k(a.renderTo,"touchmove",c),k(d.ownerDocument,"touchend",e)),h.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=h;b.series&&b.series[0]&&h.push(k(b.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};h.prototype.getPartsEvents=function(b){var a=this,d=[];["shades","handles"].forEach(function(m){a[m].forEach(function(l,h){d.push(k(l.element,b,function(b){a[m+
"Mousedown"](b,h)}))})});return d};h.prototype.shadesMousedown=function(b,a){b=this.chart.pointer.normalize(b);var m=this.chart,d=this.xAxis,h=this.zoomedMin,c=this.size,e=this.range,g=this.left,n=b.chartX;m.inverted&&(n=b.chartY,g=this.top);if(1===a)this.grabbedCenter=n,this.fixedWidth=e,this.dragOffset=n-h;else{b=n-g-e/2;if(0===a)b=Math.max(0,b);else if(2===a&&b+e>=c)if(b=c-e,this.reversedExtremes){b-=e;var k=this.getUnionExtremes().dataMin}else var p=this.getUnionExtremes().dataMax;b!==h&&(this.fixedWidth=
e,a=d.navigatorAxis.toFixedRange(b,b+e,k,p),J(a.min)&&m.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};h.prototype.handlesMousedown=function(b,a){this.chart.pointer.normalize(b);b=this.chart;var m=b.xAxis[0],d=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?m.min:m.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?m.max:m.min);b.fixedRange=null};h.prototype.onMouseMove=
function(b){var a=this,d=a.chart,h=a.navigatorSize,c=a.range,g=a.dragOffset,n=d.inverted,k=a.left;b.touches&&0===b.touches[0].pageX||(b=d.pointer.normalize(b),d=b.chartX,n&&(k=a.top,d=b.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,d-k,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,d-k)):a.grabbedCenter&&(a.hasDragged=!0,d<g?d=g:d>h+g-c&&(d=h+g-c),a.render(0,0,d-g,d-g+c)),a.hasDragged&&a.scrollbar&&v(a.scrollbar.options.liveRedraw,y.svg&&!e&&!this.chart.boosted)&&
(b.DOMType=b.type,setTimeout(function(){a.onMouseUp(b)},0)))};h.prototype.onMouseUp=function(b){var a=this.chart,d=this.xAxis,h=this.scrollbar,c=b.DOMEvent||b,e=a.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===b.trigger){h=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var n=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var k=this.fixedExtreme;this.zoomedMax===this.size&&(k=this.reversedExtremes?
h.dataMin:h.dataMax);0===this.zoomedMin&&(n=this.reversedExtremes?h.dataMax:h.dataMin);d=d.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,n,k);J(d.min)&&a.xAxis[0].setExtremes(Math.min(d.min,d.max),Math.max(d.min,d.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=
null);this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(a=Math.round(this.zoomedMin),b=Math.round(this.zoomedMax),this.shades&&this.drawMasks(a,b,e,g),this.outline&&this.drawOutline(a,b,e,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,e,g),this.drawHandle(b,1,e,g)))};h.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};
h.prototype.removeBaseSeriesEvents=function(){var b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){n(b,"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&n(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};h.prototype.init=function(b){var d=b.options,l=d.navigator||{},h=l.enabled,c=d.scrollbar||{},e=c.enabled;d=h&&l.height||0;var g=e&&c.height||0;this.handles=[];this.shades=[];this.chart=b;this.setBaseSeries();
this.height=d;this.scrollbarHeight=g;this.scrollbarEnabled=e;this.navigatorEnabled=h;this.navigatorOptions=l;this.scrollbarOptions=c;this.outlineHeight=d+g;this.opposite=v(l.opposite,!(h||!b.inverted));var n=this;h=n.baseSeries;c=b.xAxis.length;e=b.yAxis.length;var p=h&&h[0]&&h[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;n.navigatorEnabled?(n.xAxis=new a(b,G({breaks:p.options.breaks,ordinal:p.options.ordinal},l.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:c,
isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[g,0,-g,0],width:d}:{offsets:[0,-g,0,g],height:d})),n.yAxis=new a(b,G(l.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:v(l.yAxis&&l.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:d}:{height:d})),h||l.series.data?n.updateNavigatorSeries(!1):0===b.series.length&&(n.unbindRedraw=k(b,"beforeRedraw",
function(){0<b.series.length&&!n.series&&(n.setBaseSeries(),n.unbindRedraw())})),n.reversedExtremes=b.inverted&&!n.xAxis.reversed||!b.inverted&&n.xAxis.reversed,n.renderElements(),n.addMouseEvents()):(n.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,d){var m=b.xAxis[0],l=m.getExtremes(),h=m.len-2*g,c=z("min",m.options.min,l.dataMin);m=z("max",m.options.max,l.dataMax)-c;return d?a*m/h+c:h*(a-c)/m},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,
!0)}},n.xAxis.navigatorAxis.axis=n.xAxis,n.xAxis.navigatorAxis.toFixedRange=f.prototype.toFixedRange.bind(n.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(b.scrollbar=n.scrollbar=new B(b.renderer,G(b.options.scrollbar,{margin:n.navigatorEnabled?0:10,vertical:b.inverted}),b),k(n.scrollbar,"changed",function(b){var a=n.size,d=a*this.to;a*=this.from;n.hasDragged=n.scrollbar.hasDragged;n.render(0,0,a,d);this.shouldUpdateExtremes(b.DOMType)&&setTimeout(function(){n.onMouseUp(b)})}));n.addBaseSeriesEvents();
n.addChartEvents()};h.prototype.getUnionExtremes=function(b){var a=this.chart.xAxis[0],d=this.xAxis,h=d.options,c=a.options,e;b&&null===a.dataMin||(e={dataMin:v(h&&h.min,z("min",c.min,a.dataMin,d.dataMin,d.min)),dataMax:v(h&&h.max,z("max",c.max,a.dataMax,d.dataMax,d.max))});return e};h.prototype.setBaseSeries=function(b,a){var d=this.chart,m=this.baseSeries=[];b=b||d.options&&d.options.navigator.baseSeries||(d.series.length?C(d.series,function(b){return!b.options.isInternal}).index:0);(d.series||
[]).forEach(function(a,d){a.options.isInternal||!a.options.showInNavigator&&(d!==b&&a.options.id!==b||!1===a.options.showInNavigator)||m.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)};h.prototype.updateNavigatorSeries=function(b,a){var m=this,h=m.chart,c=m.baseSeries,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},
g=m.series=(m.series||[]).filter(function(b){var a=b.baseSeries;return 0>c.indexOf(a)?(a&&(n(a,"updatedData",m.updatedDataHandler),delete a.navigatorSeries),b.chart&&b.destroy(),!1):!0}),k,p,f=m.navigatorOptions.series,I;c&&c.length&&c.forEach(function(b){var l=b.navigatorSeries,n=E({color:b.color,visible:b.visible},F(f)?r.navigator.series:f);l&&!1===m.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+c.length,k=b.options||{},I=k.navigatorOptions||{},n.dataLabels=d(n.dataLabels),p=G(k,e,n,
I),p.pointRange=v(n.pointRange,I.pointRange,r.plotOptions[p.type||"line"].pointRange),n=I.data||n.data,m.hasNavigatorData=m.hasNavigatorData||!!n,p.data=n||k.data&&k.data.slice(0),l&&l.options?l.update(p,a):(b.navigatorSeries=h.initSeries(p),b.navigatorSeries.baseSeries=b,g.push(b.navigatorSeries)))});if(f.data&&(!c||!c.length)||F(f))m.hasNavigatorData=!1,f=d(f),f.forEach(function(b,a){e.name="Navigator "+(g.length+1);p=G(r.navigator.series,{color:h.series[a]&&!h.series[a].options.isInternal&&h.series[a].color||
h.options.colors[a]||h.options.colors[0]},e,b);p.data=b.data;p.data&&(m.hasNavigatorData=!0,g.push(h.initSeries(p)))});b&&this.addBaseSeriesEvents()};h.prototype.addBaseSeriesEvents=function(){var b=this,a=this,d=a.baseSeries||[];d[0]&&d[0].xAxis&&d[0].eventsToUnbind.push(k(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));d.forEach(function(d){d.eventsToUnbind.push(k(d,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));d.eventsToUnbind.push(k(d,"hide",function(){this.navigatorSeries&&
this.navigatorSeries.setVisible(!1,!1)}));!1!==b.navigatorOptions.adaptToUpdatedData&&d.xAxis&&d.eventsToUnbind.push(k(d,"updatedData",b.updatedDataHandler));d.eventsToUnbind.push(k(d,"remove",function(){this.navigatorSeries&&(D(a.series,this.navigatorSeries),J(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})};h.prototype.getBaseSeriesMin=function(b){return this.baseSeries.reduce(function(b,a){return Math.min(b,a.xData&&a.xData.length?a.xData[0]:b)},
b)};h.prototype.modifyNavigatorAxisExtremes=function(){var b=this.xAxis;if("undefined"!==typeof b.getExtremes){var a=this.getUnionExtremes(!0);!a||a.dataMin===b.min&&a.dataMax===b.max||(b.min=a.dataMin,b.max=a.dataMax)}};h.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,d=this.getExtremes(),l=d.dataMin,h=d.dataMax;d=d.max-d.min;var c=a.stickToMin,e=a.stickToMax,g=v(this.options.overscroll,0),n=a.series&&a.series[0],k=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==
this.eventArgs.trigger){if(c){var p=l;var r=p+d}e&&(r=h+g,c||(p=Math.max(l,r-d,a.getBaseSeriesMin(n&&n.xData?n.xData[0]:-Number.MAX_VALUE))));k&&(c||e)&&x(p)&&(this.min=this.userMin=p,this.max=this.userMax=r)}a.stickToMin=a.stickToMax=null};h.prototype.updatedDataHandler=function(){var a=this.chart.navigator,d=this.navigatorSeries;a.stickToMax=v(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size));
a.stickToMin=a.shouldStickToMin(this,a);d&&!a.hasNavigatorData&&(d.options.pointStart=this.xData[0],d.setData(this.options.data,!1,null,!1))};h.prototype.shouldStickToMin=function(a,d){d=d.getBaseSeriesMin(a.xData[0]);var b=a.xAxis;a=b.max;var m=b.min;b=b.options.range;return x(a)&&x(m)?b&&0<a-d?a-d<b:m<=d:!1};h.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(k(this.chart,"redraw",function(){var a=this.navigator,d=a&&(a.baseSeries&&a.baseSeries[0]&&
a.baseSeries[0].xAxis||this.xAxis[0]);d&&a.render(d.min,d.max)}),k(this.chart,"getMargins",function(){var a=this.navigator,d=a.opposite?"plotTop":"marginBottom";this.inverted&&(d=a.opposite?"marginRight":"plotLeft");this[d]=(this[d]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};h.prototype.destroy=function(){var a=this;this.removeEvents();this.xAxis&&(D(this.chart.xAxis,this.xAxis),D(this.chart.axes,this.xAxis));this.yAxis&&(D(this.chart.yAxis,this.yAxis),
D(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(b){a[b]&&a[b].destroy&&a[b].destroy();a[b]=null});[this.handles].forEach(function(a){g(a)})};return h}()});C(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,
buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}}});
C(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Core/Utilities.js"]],function(a,q,y){function f(){var a=this.range,d=a.type,h=this.max,b=this.chart.time,m=function(a,m){var h="year"===d?"FullYear":"Month",l=new b.Date(a),c=b.get(h,l);b.set(h,l,c+m);c===b.get(h,l)&&b.set("Date",l,0);return l.getTime()-a};if(E(a)){var l=h-a;var c=a}else a&&(l=h+m(h,-(a.count||1)),this.chart&&(this.chart.fixedRange=h-l));var e=F(this.dataMin,
Number.MIN_VALUE);E(l)||(l=e);l<=e&&(l=e,"undefined"===typeof c&&(c=m(l,a.count)),this.newMax=Math.min(l+c,F(this.dataMax,Number.MAX_VALUE)));E(h)?!E(a)&&a&&a._offsetMin&&(l+=a._offsetMin):l=void 0;return l}function u(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new v(this))}function B(){var a=this.axes,d=this.rangeSelector;d&&(E(d.deferredYTDClick)&&(d.clickButton(d.deferredYTDClick),delete d.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),d.render(),a=d.options.verticalAlign,d.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}function w(a){var d,h,b,m,l=a.rangeSelector,e=function(){l&&(d=a.xAxis[0].getExtremes(),h=a.legend,m=l&&l.options.verticalAlign,E(d.min)&&l.render(d.min,d.max),h.display&&"top"===m&&m===h.options.verticalAlign&&(b=C(a.spacingBox),b.y="vertical"===h.options.layout?a.plotTop:b.y+l.getHeight(),h.group.placed=!1,h.align(b)))};l&&(D(x,function(b){return b[0]===
a})||x.push([a,[c(a.xAxis[0],"afterSetExtremes",function(a){l&&l.render(a.min,a.max)}),c(a,"redraw",e)]]),e())}function z(){for(var a=0,d=x.length;a<d;++a){var h=x[a];if(h[0]===this){h[1].forEach(function(a){return a()});x.splice(a,1);break}}}function r(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function p(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?
this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function e(a){var d=a.options.rangeSelector;a=this.extraBottomMargin;var h=this.extraTopMargin,b=this.rangeSelector;d&&d.enabled&&!J(b)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=b=new v(this));this.extraTopMargin=this.extraBottomMargin=!1;b&&(w(this),d=d&&d.verticalAlign||b.options&&b.options.verticalAlign,b.options.floating||("bottom"===d?this.extraBottomMargin=!0:"middle"!==d&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==a||this.extraTopMargin!==h)&&(this.isDirtyBox=!0)}var k=a.defaultOptions,t=a.setOptions,c=y.addEvent,J=y.defined,g=y.extend,D=y.find,E=y.isNumber,C=y.merge,F=y.pick,x=[],G=[],v;return{compose:function(a,d,h){v=h;-1===G.indexOf(a)&&(G.push(a),a.prototype.minFromRange=f);-1===G.indexOf(d)&&(G.push(d),c(d,"afterGetContainer",u),c(d,"beforeRender",B),c(d,"destroy",z),c(d,"getMargins",r),c(d,"render",p),c(d,"update",e),d.prototype.callbacks.push(w));-1===G.indexOf(t)&&(g(k,
{rangeSelector:q.rangeSelector}),g(k.lang,q.lang))}}});C(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,y,f,u,B){function w(a){if(-1!==a.indexOf("%L"))return"text";var d="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),h="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return d&&
h?"datetime-local":d?"date":h?"time":"text"}var z=q.defaultOptions,r=B.addEvent,p=B.createElement,e=B.css,k=B.defined,t=B.destroyObjectProperties,c=B.discardElement,J=B.extend,g=B.fireEvent,D=B.isNumber,E=B.merge,C=B.objectEach,F=B.pad,x=B.pick,G=B.pInt,v=B.splat;q=function(){function n(a){this.buttons=void 0;this.buttonOptions=n.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}n.compose=function(a,h){f.compose(a,h,n)};n.prototype.clickButton=function(d,
h){var b=this.chart,m=this.buttonOptions[d],l=b.xAxis[0],c=b.scroller&&b.scroller.getUnionExtremes()||l||{},e=m.type,n=m.dataGrouping,p=c.dataMin,f=c.dataMax,t=l&&Math.round(Math.min(l.max,x(f,l.max)));c=m._range;var w,I=!0;if(null!==p&&null!==f){b.fixedRange=c;this.setSelected(d);n&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(l||{chart:this.chart},n,!1),this.frozenStates=m.preserveDataGrouping);if("month"===e||"year"===e)if(l){e={range:m,max:t,chart:b,dataMin:p,dataMax:f};var u=
l.minFromRange.call(e);D(e.newMax)&&(t=e.newMax);I=!1}else c=m;else if(c)u=Math.max(t-c,p),t=Math.min(u+c,f),I=!1;else if("ytd"===e)if(l){if("undefined"===typeof f||"undefined"===typeof p)p=Number.MAX_VALUE,f=Number.MIN_VALUE,b.series.forEach(function(a){if(a=a.xData)p=Math.min(a[0],p),f=Math.max(a[a.length-1],f)}),h=!1;e=this.getYTDExtremes(f,p,b.time.useUTC);u=w=e.min;t=e.max}else{this.deferredYTDClick=d;return}else"all"===e&&l&&(b.navigator&&b.navigator.baseSeries[0]&&(b.navigator.baseSeries[0].xAxis.options.range=
void 0),u=p,t=f);I&&m._offsetMin&&k(u)&&(u+=m._offsetMin);m._offsetMax&&k(t)&&(t+=m._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);if(l)l.setExtremes(u,t,x(h,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:m});else{var q=v(b.options.xAxis)[0];var z=q.range;q.range=c;var B=q.min;q.min=w;r(b,"load",function(){q.range=z;q.min=B})}g(this,"afterBtnClick")}};n.prototype.setSelected=function(a){this.selected=this.options.selected=a};n.prototype.init=function(a){var d=this,b=a.options.rangeSelector,
m=b.buttons||d.defaultButtons.slice(),l=b.selected,c=function(){var a=d.minInput,b=d.maxInput;a&&a.blur&&g(a,"blur");b&&b.blur&&g(b,"blur")};d.chart=a;d.options=b;d.buttons=[];d.buttonOptions=m;this.eventsToUnbind=[];this.eventsToUnbind.push(r(a.container,"mousedown",c));this.eventsToUnbind.push(r(a,"resize",c));m.forEach(d.computeButtonRange);"undefined"!==typeof l&&m[l]&&this.clickButton(l,!1);this.eventsToUnbind.push(r(a,"load",function(){a.xAxis&&a.xAxis[0]&&r(a.xAxis[0],"setExtremes",function(b){this.max-
this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})}))};n.prototype.updateButtonStates=function(){var a=this,h=this.chart,b=this.dropdown,m=h.xAxis[0],l=Math.round(m.max-m.min),c=!m.hasVisibleSeries,e=h.scroller&&h.scroller.getUnionExtremes()||m,g=e.dataMin,k=e.dataMax;h=a.getYTDExtremes(k,g,h.time.useUTC);var n=h.min,p=h.max,r=a.selected,f=a.options.allButtonsEnabled,t=a.buttons,v=D(r);a.buttonOptions.forEach(function(d,
h){var e=d._range,A=d.type,M=d.count||1,K=t[h],I=d._offsetMax-d._offsetMin,w=h===r,u=e>k-g,x=e<m.minRange;d=0;var H=!1,q=!1;e=e===l;("month"===A||"year"===A)&&l+36E5>=864E5*{month:28,year:365}[A]*M-I&&l-36E5<=864E5*{month:31,year:366}[A]*M+I?e=!0:"ytd"===A?(e=p-n+I===l,H=!w):"all"===A&&(e=m.max-m.min>=k-g,q=!w&&v&&e);A=!f&&(u||x||q||c);M=w&&e||e&&!v&&!H||w&&a.frozenStates;A?d=3:M&&(v=!0,d=2);K.state!==d&&(K.setState(d),b&&(b.options[h+1].disabled=A,2===d&&(b.selectedIndex=h+1)),0===d&&r===h&&a.setSelected())})};
n.prototype.computeButtonRange=function(a){var d=a.type,b=a.count||1,m={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(m[d])a._range=m[d]*b;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*b;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};n.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var d=this.chart.options.rangeSelector,b=this.chart.time;return a?("text"===a.type&&d.inputDateParser||
this.defaultInputDateParser)(a.value,b.useUTC,b):0};n.prototype.setInputValue=function(a,h){var b=this.options,d=this.chart.time,l="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(l){var c=l.getAttribute("data-hc-time");c=k(c)?Number(c):void 0;k(h)&&(k(c)&&l.setAttribute("data-hc-time-previous",c),l.setAttribute("data-hc-time",h),c=h);l.value=d.dateFormat(this.inputTypeFormats[l.type]||b.inputEditDateFormat,c);a&&a.attr({text:d.dateFormat(b.inputDateFormat,c)})}};
n.prototype.setInputExtremes=function(a,h,b){if(a="min"===a?this.minInput:this.maxInput){var d=this.inputTypeFormats[a.type],l=this.chart.time;d&&(h=l.dateFormat(d,h),a.min!==h&&(a.min=h),b=l.dateFormat(d,b),a.max!==b&&(a.max=b))}};n.prototype.showInput=function(a){var d="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&d&&this.inputGroup){var b="text"===a.type,m=this.inputGroup,l=m.translateX;m=m.translateY;var c=this.options.inputBoxWidth;e(a,{width:b?d.width+
(c?-2:20)+"px":"auto",height:b?d.height-2+"px":"auto",border:"2px solid silver"});b&&c?e(a,{left:l+d.x+"px",top:m+"px"}):e(a,{left:Math.min(Math.round(d.x+l-(a.offsetWidth-d.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:m-(a.offsetHeight-d.height)/2+"px"})}};n.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&e(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};n.prototype.defaultInputDateParser=function(a,c,b){var d=a.split("/").join("-").split(" ").join("T");
-1===d.indexOf("T")&&(d+="T00:00");if(c)d+="Z";else{var l;if(l=y.isSafari)l=d,l=!(6<l.length&&(l.lastIndexOf("-")===l.length-6||l.lastIndexOf("+")===l.length-6));l&&(l=(new Date(d)).getTimezoneOffset()/60,d+=0>=l?"+".concat(F(-l),":00"):"-".concat(F(l),":00"))}d=Date.parse(d);D(d)||(a=a.split("-"),d=Date.UTC(G(a[0]),G(a[1])-1,G(a[2])));b&&c&&D(d)&&(d+=b.getTimezoneOffset(d));return d};n.prototype.drawInput=function(a){function d(){var d=c.maxInput,m=c.minInput,l=b.xAxis[0],h=b.scroller&&b.scroller.xAxis?
b.scroller.xAxis:l,e=h.dataMin;h=h.dataMax;var g=c.getInputValue(a);g!==Number(t.getAttribute("data-hc-time-previous"))&&D(g)&&(t.setAttribute("data-hc-time-previous",g),r&&d&&D(e)?g>Number(d.getAttribute("data-hc-time"))?g=void 0:g<e&&(g=e):m&&D(h)&&(g<Number(m.getAttribute("data-hc-time"))?g=void 0:g>h&&(g=h)),"undefined"!==typeof g&&l.setExtremes(r?g:l.min,r?l.max:g,void 0,void 0,{trigger:"rangeSelectorInput"}))}var b=this.chart,m=this.div,l=this.inputGroup,c=this,g=b.renderer.style||{},k=b.renderer,
n=b.options.rangeSelector,r="min"===a,f=z.lang[r?"rangeSelectorFrom":"rangeSelectorTo"]||"";f=k.label(f,0).addClass("highcharts-range-label").attr({padding:f?2:0,height:f?n.inputBoxHeight:0}).add(l);k=k.label("",0).addClass("highcharts-range-input").attr({padding:2,width:n.inputBoxWidth,height:n.inputBoxHeight,"text-align":"center"}).on("click",function(){c.showInput(a);c[a+"Input"].focus()});b.styledMode||k.attr({stroke:n.inputBoxBorderColor,"stroke-width":1});k.add(l);var t=p("input",{name:a,className:"highcharts-range-selector"},
void 0,m);t.setAttribute("type",w(n.inputDateFormat||"%b %e, %Y"));b.styledMode||(f.css(E(g,n.labelStyle)),k.css(E({color:"#333333"},g,n.inputStyle)),e(t,J({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:g.fontSize,fontFamily:g.fontFamily,top:"-9999em"},n.inputStyle)));t.onfocus=function(){c.showInput(a)};t.onblur=function(){t===y.doc.activeElement&&d();c.hideInput(a);c.setInputValue(a);t.blur()};var v=!1;t.onchange=
function(){v||(d(),c.hideInput(a),t.blur())};t.onkeypress=function(a){13===a.keyCode&&d()};t.onkeydown=function(a){v=!0;38!==a.keyCode&&40!==a.keyCode||d()};t.onkeyup=function(){v=!1};return{dateBox:k,input:t,label:f}};n.prototype.getPosition=function(){var a=this.chart,c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}};n.prototype.getYTDExtremes=function(a,c,b){var d=this.chart.time,l=new d.Date(a),
h=d.get("FullYear",l);b=b?d.Date.UTC(h,0,1):+new d.Date(h,0,1);c=Math.max(c,b);l=l.getTime();return{max:Math.min(a||l,l),min:c}};n.prototype.render=function(a,c){var b=this.chart,d=b.renderer,l=b.container,h=b.options,e=h.rangeSelector,g=x(h.chart.style&&h.chart.style.zIndex,0)+1;h=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=d.g("range-selector-group").attr({zIndex:7}).add(),this.div=p("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),
l.parentNode&&l.parentNode.insertBefore(this.div,l),h&&(this.inputGroup=d.g("input-group").add(this.group),d=this.drawInput("min"),this.minDateBox=d.dateBox,this.minLabel=d.label,this.minInput=d.input,d=this.drawInput("max"),this.maxDateBox=d.dateBox,this.maxLabel=d.label,this.maxInput=d.input));if(h&&(this.setInputValue("min",a),this.setInputValue("max",c),a=b.scroller&&b.scroller.getUnionExtremes()||b.xAxis[0]||{},k(a.dataMin)&&k(a.dataMax)&&(b=b.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-b),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+b,a.dataMax)),this.inputGroup)){var n=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:n}),n+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};n.prototype.renderButtons=function(){var a=this,c=this.buttons,b=this.options,m=z.lang,l=this.chart.renderer,e=E(b.buttonTheme),k=e&&e.states,
n=e.width||28;delete e.width;delete e.states;this.buttonGroup=l.g("range-selector-buttons").add(this.group);var f=this.dropdown=p("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);r(f,"touchstart",function(){f.style.fontSize="16px"});[[y.isMS?"mouseover":"mouseenter"],[y.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(b){var d=b[0],m=b[1];r(f,d,function(){var b=c[a.currentButtonIndex()];b&&g(b.element,
m||d)})});this.zoomText=l.label(m&&m.rangeSelectorZoom||"",0).attr({padding:b.buttonTheme.padding,height:b.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(b.labelStyle),e["stroke-width"]=x(e["stroke-width"],0));p("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,f);this.buttonOptions.forEach(function(b,d){p("option",{textContent:b.title||b.text},void 0,f);c[d]=l.button(b.text,0,0,function(m){var c=b.events&&b.events.click,
l;c&&(l=c.call(b,m));!1!==l&&a.clickButton(d);a.isActive=!0},e,k&&k.hover,k&&k.select,k&&k.disabled).attr({"text-align":"center",width:n}).add(a.buttonGroup);b.title&&c[d].attr("title",b.title)})};n.prototype.alignElements=function(){var a=this,c=this.buttonGroup,b=this.buttons,m=this.chart,l=this.group,e=this.inputGroup,g=this.options,k=this.zoomText,n=m.options,p=n.exporting&&!1!==n.exporting.enabled&&n.navigation&&n.navigation.buttonOptions;n=g.buttonPosition;var f=g.inputPosition,r=g.verticalAlign,
t=function(b,d){return p&&a.titleCollision(m)&&"top"===r&&"right"===d.align&&d.y-b.getBBox().height-12<(p.y||0)+(p.height||0)+m.spacing[0]?-40:0},v=m.plotLeft;if(l&&n&&f){var w=n.x-m.spacing[3];if(c){this.positionButtons();if(!this.initialButtonGroupWidth){var u=0;k&&(u+=k.getBBox().width+5);b.forEach(function(a,d){u+=a.width;d!==b.length-1&&(u+=g.buttonSpacing)});this.initialButtonGroupWidth=u}v-=m.spacing[3];this.updateButtonStates();k=t(c,n);this.alignButtonGroup(k);l.placed=c.placed=m.hasLoaded}c=
0;e&&(c=t(e,f),"left"===f.align?w=v:"right"===f.align&&(w=-Math.max(m.axisOffset[1],-c)),e.align({y:f.y,width:e.getBBox().width,align:f.align,x:f.x+w-2},!0,m.spacingBox),e.placed=m.hasLoaded);this.handleCollision(c);l.align({verticalAlign:r},!0,m.spacingBox);e=l.alignAttr.translateY;c=l.getBBox().height+20;t=0;"bottom"===r&&(t=(t=m.legend&&m.legend.options)&&"bottom"===t.verticalAlign&&t.enabled&&!t.floating?m.legend.legendHeight+x(t.margin,10):0,c=c+t-20,t=e-c-(g.floating?0:g.y)-(m.titleOffset?m.titleOffset[2]:
0)-10);if("top"===r)g.floating&&(t=0),m.titleOffset&&m.titleOffset[0]&&(t=m.titleOffset[0]),t+=m.margin[0]-m.spacing[0]||0;else if("middle"===r)if(f.y===n.y)t=e;else if(f.y||n.y)t=0>f.y||0>n.y?t-Math.min(f.y,n.y):e-c;l.translate(g.x,g.y+Math.floor(t));n=this.minInput;f=this.maxInput;e=this.dropdown;g.inputEnabled&&n&&f&&(n.style.marginTop=l.translateY+"px",f.style.marginTop=l.translateY+"px");e&&(e.style.marginTop=l.translateY+"px")}};n.prototype.alignButtonGroup=function(a,c){var b=this.chart,d=
this.buttonGroup,l=this.options.buttonPosition,e=b.plotLeft-b.spacing[3],h=l.x-b.spacing[3];"right"===l.align?h+=a-e:"center"===l.align&&(h-=e/2);d&&d.align({y:l.y,width:x(c,this.initialButtonGroupWidth),align:l.align,x:h},!0,b.spacingBox)};n.prototype.positionButtons=function(){var a=this.buttons,c=this.chart,b=this.options,m=this.zoomText,l=c.hasLoaded?"animate":"attr",e=b.buttonPosition,g=c=c.plotLeft;m&&"hidden"!==m.visibility&&(m[l]({x:x(c+e.x,c)}),g+=e.x+m.getBBox().width+5);m=0;for(e=this.buttonOptions.length;m<
e;++m)if("hidden"!==a[m].visibility)a[m][l]({x:g}),g+=a[m].width+b.buttonSpacing;else a[m][l]({x:c})};n.prototype.handleCollision=function(a){var d=this,b=this.chart,c=this.buttonGroup,l=this.inputGroup,e=this.options,g=e.buttonPosition,k=e.dropdown,n=e.inputPosition;e=function(){var a=0;d.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var p=function(b){if(l&&c){var d=l.alignAttr.translateX+l.alignOptions.x-a+l.getBBox().x+2,m=l.alignOptions.width,e=c.alignAttr.translateX+
c.getBBox().x;return e+b>d&&d+m>e&&g.y<n.y+l.getBBox().height}return!1},f=function(){l&&c&&l.attr({translateX:l.alignAttr.translateX+(b.axisOffset[1]>=-a?0:-a),translateY:l.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===k){this.collapseButtons(a);p(e())&&f();return}"never"===k&&this.expandButtons()}l&&c?n.align===g.align||p(this.initialButtonGroupWidth+20)?"responsive"===k?(this.collapseButtons(a),p(e())&&f()):f():"responsive"===k&&this.expandButtons():c&&"responsive"===k&&(this.initialButtonGroupWidth>
b.plotWidth?this.collapseButtons(a):this.expandButtons())};n.prototype.collapseButtons=function(a){var d=this.buttons,b=this.buttonOptions,c=this.chart,l=this.dropdown,e=this.options,g=this.zoomText,k=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||{},n=function(a){return{text:a?""+a+" \u25be":"\u25be",width:"auto",paddingLeft:x(e.buttonTheme.paddingLeft,k.padding,8),paddingRight:x(e.buttonTheme.paddingRight,k.padding,8)}};g&&g.hide();var p=!1;b.forEach(function(a,b){b=d[b];
2!==b.state?b.hide():(b.show(),b.attr(n(a.text)),p=!0)});p||(l&&(l.selectedIndex=0),d[0].show(),d[0].attr(n(this.zoomText&&this.zoomText.textStr)));b=e.buttonPosition.align;this.positionButtons();"right"!==b&&"center"!==b||this.alignButtonGroup(a,d[this.currentButtonIndex()].getBBox().width);this.showDropdown()};n.prototype.expandButtons=function(){var a=this.buttons,c=this.buttonOptions,b=this.options,m=this.zoomText;this.hideDropdown();m&&m.show();c.forEach(function(d,c){c=a[c];c.show();c.attr({text:d.text,
width:b.buttonTheme.width||28,paddingLeft:x(b.buttonTheme.paddingLeft,"unset"),paddingRight:x(b.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};n.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};n.prototype.showDropdown=function(){var a=this.buttonGroup,c=this.buttons,b=this.chart,m=this.dropdown;if(a&&m){var l=a.translateX;a=a.translateY;c=c[this.currentButtonIndex()].getBBox();e(m,{left:b.plotLeft+
l+"px",top:a+.5+"px",width:c.width+"px",height:c.height+"px"});this.hasVisibleDropdown=!0}};n.prototype.hideDropdown=function(){var a=this.dropdown;a&&(e(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};n.prototype.getHeight=function(){var a=this.options,c=this.group,b=a.y,m=a.buttonPosition.y,l=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=c?c.getBBox(!0).height+13+b:0;c=Math.min(l,m);if(0>l&&0>m||0<l&&0<m)a+=Math.abs(c);return a};n.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};n.prototype.update=function(a){var d=this.chart;E(!0,d.options.rangeSelector,a);this.destroy();this.init(d);this.render()};n.prototype.destroy=function(){var a=this,e=a.minInput,b=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);t(a.buttons);e&&(e.onfocus=e.onblur=e.onchange=null);b&&(b.onfocus=b.onblur=b.onchange=null);C(a,function(b,d){b&&"chart"!==d&&(b instanceof u?b.destroy():
b instanceof window.HTMLElement&&c(b));b!==n.prototype[d]&&(a[d]=null)},this)};return n}();J(q.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"}});"";return q});C(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y,f){var u=f.addEvent,B=f.correctFloat,w=f.css,z=f.defined,r=f.error,p=f.pick,e=f.timeUnits,k=[],t;(function(a){function c(a,d,c,h,g,k,n){void 0===g&&(g=[]);void 0===k&&(k=0);var b={},m=this.options.tickPixelInterval,l=this.chart.time,p=[],f,t,A=0,v=[],w=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!g||3>g.length||
"undefined"===typeof d)return l.getTimeTicks.apply(l,arguments);var u=g.length;for(f=0;f<u;f++){var x=f&&g[f-1]>c;g[f]<d&&(A=f);if(f===u-1||g[f+1]-g[f]>5*k||x){if(g[f]>w){for(t=l.getTimeTicks(a,g[A],g[f],h);t.length&&t[0]<=w;)t.shift();t.length&&(w=t[t.length-1]);p.push(v.length);v=v.concat(t)}A=f+1}if(x)break}if(t){t=t.info;if(n&&t.unitRange<=e.hour){f=v.length-1;for(A=1;A<f;A++)if(l.dateFormat("%d",v[A])!==l.dateFormat("%d",v[A-1])){b[v[A]]="day";var q=!0}q&&(b[v[0]]="day");t.higherRanks=b}t.segmentStarts=
p;v.info=t}else r(12,!1,this.chart);if(n&&z(m)){t=v.length;l=[];A=[];f=void 0;for(q=t;q--;)p=this.translate(v[q]),f&&(A[q]=f-p),l[q]=f=p;A.sort();A=A[Math.floor(A.length/2)];A<.6*m&&(A=null);q=v[t-1]>c?t-1:t;for(f=void 0;q--;)p=l[q],t=Math.abs(f-p),f&&t<.8*m&&(null===A||t<.8*A)?(b[v[q]]&&!b[v[q+1]]?(t=q+1,f=p):t=q,v.splice(t,1)):f=p}return v}function g(a){var b=this.ordinal.positions;if(!b)return a;var d=b.length-1;if(0>a)a=b[0];else if(a>d)a=b[d];else{d=Math.floor(a);var c=a-d}return"undefined"!==
typeof c&&"undefined"!==typeof b[d]?b[d]+(c?c*(b[d+1]-b[d]):0):a}function f(a){var b=this.ordinal,d=b.positions;if(!d)return a;var c=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<c&&c<this.left+this.len||(b.extendedOrdinalPositions||(b.extendedOrdinalPositions=b.getExtendedPositions()),d=b.extendedOrdinalPositions);if(d&&d.length){a=b.getIndexOfPoint(c,d);b=B(a%1);if(0<=a&&a<d.length-1)return d[Math.floor(a)]+b*(d[Math.ceil(a)]-d[Math.floor(a)]);
b=d.length;c=d[0];d=d[b-1];var e=(d-c)/(b-1);return 0>a?c+e*a:d+e*(a-b)}return a}function t(b,d){var c=a.Additions.findIndexOf(b,d,!0);return b[c]===d?c:c+(d-b[c])/(b[c+1]-b[c])}function E(){this.ordinal||(this.ordinal=new a.Additions(this))}function F(){this.isXAxis&&z(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&z(this.userMin)&&
(this.min+=this.options.overscroll))}function x(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function G(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function v(a){var b=this.xAxis[0],d=b.options.overscroll,c=a.originalEvent.chartX,e=this.options.chart.panning,g=!1;if(e&&"y"!==e.type&&b.options.ordinal&&b.series.length){var h=this.mouseDownX,
k=b.getExtremes(),n=k.dataMax,p=k.min,f=k.max,t=this.hoverPoints,r=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;h=(h-c)/(b.translationSlope*(b.ordinal.slope||r));r=b.ordinal.getExtendedPositions();r={ordinal:{positions:r,extendedOrdinalPositions:r}};var v=b.index2val,q=b.val2lin,u=void 0,x=u=void 0,z=void 0;r.ordinal.positions?1<Math.abs(h)&&(t&&t.forEach(function(a){a.setState()}),0>h?(x=r,z=b.ordinal.positions?b:r):(x=b.ordinal.positions?b:r,z=r),u=z.ordinal.positions,n>u[u.length-
1]&&u.push(n),this.fixedRange=f-p,u=b.navigatorAxis.toFixedRange(void 0,void 0,v.apply(x,[q.apply(x,[p,!0])+h]),v.apply(z,[q.apply(z,[f,!0])+h])),u.min>=Math.min(k.dataMin,p)&&u.max<=Math.max(n,f)+d&&b.setExtremes(u.min,u.max,!0,!1,{trigger:"pan"}),this.mouseDownX=c,w(this.container,{cursor:"move"})):g=!0}else g=!0;g||e&&/y/.test(e.type)?d&&(b.max=b.dataMax+d):a.preventDefault()}function n(){var a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}
function d(a,d){var b=this.ordinal,c=b.positions,e=b.slope,m=b.extendedOrdinalPositions;if(!c)return a;var g=c.length;if(c[0]<=a&&c[g-1]>=a)a=t(c,a);else{m||(m=b.getExtendedPositions&&b.getExtendedPositions(),b.extendedOrdinalPositions=m);if(!m||!m.length)return a;g=m.length;e||(e=(m[g-1]-m[0])/g);c=t(m,c[0]);a>=m[0]&&a<=m[g-1]?a=t(m,a)-c:a<m[0]?(a=m[0]-a,a=-c-a/e):(a-=m[g-1],a=a/e+g-c)}return d?a:e*(a||0)+b.offset}a.compose=function(a,e,l){if(-1===k.indexOf(a)){k.push(a);var b=a.prototype;b.getTimeTicks=
c;b.index2val=g;b.lin2val=f;b.val2lin=d;b.ordinal2lin=b.val2lin;u(a,"afterInit",E);u(a,"foundExtremes",F);u(a,"afterSetScale",x);u(a,"initialAxisTranslation",G)}-1===k.indexOf(l)&&(k.push(l),u(l,"pan",v));-1===k.indexOf(e)&&(k.push(e),u(e,"updatedData",n));return a};var h=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,b=a.ordinal,d=a.getExtremes(),c=d.min,e=d.max,g=a.isXAxis&&!!a.options.breaks;d=a.options.ordinal;var h=a.chart.options.chart.ignoreHiddenSeries,
k,n,f=[],t=Number.MAX_VALUE,r=!1,v=!1,u=!1;if(d||g){var w=0;a.series.forEach(function(a,b){k=[];0<b&&"highcharts-navigator-series"!==a.options.id&&1<a.processedXData.length&&(v=w!==a.processedXData[1]-a.processedXData[0]);w=a.processedXData[1]-a.processedXData[0];a.boosted&&(u=a.boosted);if(!(h&&!1===a.visible||!1===a.takeOrdinalPosition&&!g)&&(f=f.concat(a.processedXData),q=f.length,f.sort(function(a,b){return a-b}),t=Math.min(t,p(a.closestPointRange,t)),q)){for(b=0;b<q-1;)f[b]!==f[b+1]&&k.push(f[b+
1]),b++;k[0]!==f[0]&&k.unshift(f[0]);f=k}});v&&u&&(f.pop(),f.shift());var q=f.length;if(2<q){var x=f[1]-f[0];for(n=q-1;n--&&!r;)f[n+1]-f[n]!==x&&(r=!0);!a.options.keepOrdinalPadding&&(f[0]-c>x||e-f[f.length-1]>x)&&(r=!0)}else a.options.overscroll&&(2===q?t=f[1]-f[0]:1===q?(t=a.options.overscroll,f=[f[0],f[0]+t]):t=b.overscrollPointsRange);r||a.forceOrdinal?(a.options.overscroll&&(b.overscrollPointsRange=t,f=f.concat(b.getOverscrollPositions())),b.positions=f,x=a.ordinal2lin(Math.max(c,f[0]),!0),n=
Math.max(a.ordinal2lin(Math.min(e,f[f.length-1]),!0),1),b.slope=e=(e-c)/(n-x),b.offset=c-x*e):(b.overscrollPointsRange=p(a.closestPointRange,b.overscrollPointsRange),b.positions=a.ordinal.slope=b.offset=void 0)}a.isOrdinal=d&&r;b.groupIntervalFactor=null};a.findIndexOf=function(a,b,d){for(var c=0,e=a.length-1,g;c<e;)g=Math.ceil((c+e)/2),a[g]<=b?c=g:e=g-1;return a[c]===b?c:d?c:-1};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,d=b.constructor.prototype,c=b.chart,e=b.series[0].currentDataGrouping,
g=e?e.count+e.unitName:"raw",h=b.options.overscroll,k=b.getExtremes(),n=void 0,f=a.index;f||(f=a.index={});if(!f[g]){var p={series:[],chart:c,forceOrdinal:!1,getExtremes:function(){return{min:k.dataMin,max:k.dataMax+h}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:d.ordinal2lin,getIndexOfPoint:d.getIndexOfPoint,val2lin:d.val2lin};p.ordinal.axis=p;b.series.forEach(function(b){n={xAxis:p,
xData:b.xData.slice(),chart:c,destroyGroupedData:q.noop,getProcessedData:y.prototype.getProcessedData,applyGrouping:y.prototype.applyGrouping};n.xData=n.xData.concat(a.getOverscrollPositions());n.options={dataGrouping:e?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};p.series.push(n);b.processData.apply(n)});n.closestPointRange!==n.basePointRange&&n.currentDataGrouping&&(p.forceOrdinal=!0);b.ordinal.beforeSetTickPositions.apply({axis:p});
f[g]=p.ordinal.positions}return f[g]};a.prototype.getGroupIntervalFactor=function(a,b,d){d=d.processedXData;var c=d.length,e=[];var g=this.groupIntervalFactor;if(!g){for(g=0;g<c-1;g++)e[g]=d[g+1]-d[g];e.sort(function(a,b){return a-b});e=e[Math.floor(c/2)];a=Math.max(a,d[0]);b=Math.min(b,d[c-1]);this.groupIntervalFactor=g=c*e/(b-a)}return g};a.prototype.getIndexOfPoint=function(b,d){var c=this.axis,e=this.positions?this.positions[0]:0,g=c.series[0].points&&c.series[0].points[0]&&c.series[0].points[0].plotX||
c.minPixelPadding;1<c.series.length&&c.series.forEach(function(a){a.points&&z(a.points[0])&&z(a.points[0].plotX)&&a.points[0].plotX<g&&(g=a.points[0].plotX)});b=(b-g)/(c.translationSlope*(this.slope||c.closestPointRange||this.overscrollPointsRange));return a.findIndexOf(d,e)+b};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,d=this.overscrollPointsRange,c=[],e=a.dataMax;if(z(d))for(;e<=a.dataMax+b;)e+=d,c.push(e);return c};a.prototype.postProcessTickInterval=function(a){var b=
this.axis,d=this.slope;return d?b.options.breaks?b.closestPointRange||a:a/(d/b.closestPointRange):a};return a}();a.Additions=h})(t||(t={}));return t});C(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(f,u){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var u in f)f.hasOwnProperty(u)&&(a[u]=f[u])};return a(f,u)};return function(f,u){function q(){this.constructor=
f}a(f,u);f.prototype=null===u?Object.create(u):(q.prototype=u.prototype,new q)}}();return function(a){function f(){var f=null!==a&&a.apply(this,arguments)||this;f.close=void 0;f.high=void 0;f.low=void 0;f.options=void 0;f.plotClose=void 0;f.series=void 0;return f}q(f,a);return f}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});C(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Series/HLC/HLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,f){var u=this&&this.__extends||function(){var a=function(f,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var c in e)e.hasOwnProperty(c)&&(a[c]=e[c])};return a(f,e)};return function(f,e){function k(){this.constructor=
f}a(f,e);f.prototype=null===e?Object.create(e):(k.prototype=e.prototype,new k)}}(),B=y.seriesTypes.column,w=f.extend,z=f.merge;f=function(a){function f(){var e=null!==a&&a.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;e.yData=void 0;return e}u(f,a);f.prototype.extendStem=function(a,k,f){var c=a[0];a=a[1];"number"===typeof c[2]&&(c[2]=Math.max(f+k,c[2]));"number"===typeof a[2]&&(a[2]=Math.min(f-k,a[2]))};f.prototype.getPointPath=function(a,k){k=k.strokeWidth();var e=a.series,
c=k%2/2,f=Math.round(a.plotX)-c,g=Math.round(a.shapeArgs.width/2),p=[["M",f,Math.round(a.yBottom)],["L",f,Math.round(a.plotHigh)]];null!==a.close&&(a=Math.round(a.plotClose)+c,p.push(["M",f,a],["L",f+g,a]),e.extendStem(p,k/2,a));return p};f.prototype.drawSinglePoint=function(a){var e=a.series,f=e.chart,c=a.graphic;"undefined"!==typeof a.plotY&&(c||(a.graphic=c=f.renderer.path().add(e.group)),f.styledMode||c.attr(e.pointAttribs(a,a.selected&&"select")),e=e.getPointPath(a,c),c[c?"animate":"attr"]({d:e}).addClass(a.getClassName(),
!0))};f.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};f.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};f.prototype.pointAttribs=function(e,f){e=a.prototype.pointAttribs.call(this,e,f);delete e.fill;return e};f.prototype.toYData=function(a){return[a.high,a.low,a.close]};f.prototype.translate=function(){var e=this,f=e.yAxis,p=this.pointArrayMap&&this.pointArrayMap.slice()||[],c=p.map(function(a){return"plot".concat(a.charAt(0).toUpperCase()+
a.slice(1))});c.push("yBottom");p.push("low");a.prototype.translate.apply(e);e.points.forEach(function(a){p.forEach(function(g,k){g=a[g];null!==g&&(e.dataModify&&(g=e.dataModify.modifyValue(g)),a[c[k]]=f.toPixels(g,!0))});a.tooltipPos[1]=a.plotHigh+f.pos-e.chart.plotTop})};f.defaultOptions=z(B.defaultOptions,q);return f}(B);w(f.prototype,{pointClass:a,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});
y.registerSeriesType("hlc",f);return f});C(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(f,q){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var q in f)f.hasOwnProperty(q)&&(a[q]=f[q])};return a(f,q)};return function(f,q){function u(){this.constructor=f}a(f,q);f.prototype=null===q?Object.create(q):(u.prototype=q.prototype,new u)}}();return function(a){function f(){var f=
null!==a&&a.apply(this,arguments)||this;f.open=void 0;f.options=void 0;f.plotOpen=void 0;f.series=void 0;return f}q(f,a);f.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};f.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};f.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
f.prototype.getZone=function(){var f=a.prototype.getZone.call(this);this.resolveUpColor();return f};f.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this};return f}(a.seriesTypes.hlc.prototype.pointClass)});C(a,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});
C(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Series/OHLC/OHLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,f){function u(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")}function B(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&p(this,{pointValKey:t.prototype.pointValKey,pointArrayMap:t.prototype.pointArrayMap,toYData:t.prototype.toYData})}var w=
this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};return a(c,e)};return function(c,e){function g(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}(),z=y.seriesTypes.hlc,r=f.addEvent,p=f.extend,e=f.merge,k=[],t=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=
void 0;c.points=void 0;return c}w(c,a);c.compose=function(a){for(var c=1;c<arguments.length;c++);-1===k.indexOf(a)&&(k.push(a),r(a,"afterSetOptions",u),r(a,"init",B))};c.prototype.getPointPath=function(c,e){var g=a.prototype.getPointPath.call(this,c,e);e=e.strokeWidth();var f=e%2/2,k=Math.round(c.plotX)-f,p=Math.round(c.shapeArgs.width/2);null!==c.open&&(c=Math.round(c.plotOpen)+f,g.push(["M",k,c],["L",k-p,c]),a.prototype.extendStem.call(this,g,e/2,c));return g};c.prototype.pointAttribs=function(c,
e){e=a.prototype.pointAttribs.call(this,c,e);var g=this.options;delete e.fill;!c.options.color&&g.upColor&&c.open<c.close&&(e.stroke=g.upColor);return e};c.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};c.defaultOptions=e(z.defaultOptions,q);return c}(z);p(t.prototype,{pointClass:a,pointArrayMap:["open","high","low","close"]});y.registerSeriesType("ohlc",t);return t});C(a,"Series/Candlestick/CandlestickSeriesDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,
q){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}});C(a,"Series/Candlestick/CandlestickSeries.js",[a["Series/Candlestick/CandlestickSeriesDefaults.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,f){var u=this&&this.__extends||function(){var a=function(e,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&
(a[e]=c[e])};return a(e,f)};return function(e,f){function k(){this.constructor=e}a(e,f);e.prototype=null===f?Object.create(f):(k.prototype=f.prototype,new k)}}(),B=q.defaultOptions;q=y.seriesTypes;var w=q.column,z=q.ohlc,r=f.merge;f=function(f){function e(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}u(e,f);e.prototype.pointAttribs=function(a,e){var c=w.prototype.pointAttribs.call(this,a,e),f=this.options,g=a.open<a.close,k=f.lineColor||this.color,
p=a.color||this.color;c["stroke-width"]=f.lineWidth;c.fill=a.options.color||(g?f.upColor||p:p);c.stroke=a.options.lineColor||(g?f.upLineColor||k:k);e&&(a=f.states[e],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};e.prototype.drawPoints=function(){for(var a=this.chart,e=this.yAxis.reversed,c=0,f=this.points;c<f.length;c++){var g=f[c],p=g.graphic,r=!p;if("undefined"!==typeof g.plotY){p||(g.graphic=p=a.renderer.path().add(this.group));
this.chart.styledMode||p.attr(this.pointAttribs(g,g.selected&&"select")).shadow(this.options.shadow);var q=p.strokeWidth()%2/2;var u=Math.round(g.plotX)-q;var x=g.plotOpen;var w=g.plotClose;var v=Math.min(x,w);x=Math.max(x,w);var n=Math.round(g.shapeArgs.width/2);w=e?x!==g.yBottom:Math.round(v)!==Math.round(g.plotHigh);var d=e?Math.round(v)!==Math.round(g.plotHigh):x!==g.yBottom;v=Math.round(v)+q;x=Math.round(x)+q;q=[];q.push(["M",u-n,x],["L",u-n,v],["L",u+n,v],["L",u+n,x],["Z"],["M",u,v],["L",u,
w?Math.round(e?g.yBottom:g.plotHigh):v],["M",u,x],["L",u,d?Math.round(e?g.plotHigh:g.yBottom):x]);p[r?"attr":"animate"]({d:q}).addClass(g.getClassName(),!0)}}};e.defaultOptions=r(z.defaultOptions,B.plotOptions,{tooltip:z.defaultOptions.tooltip},a);return e}(z);y.registerSeriesType("candlestick",f);return f});C(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q){var y=this&&this.__extends||function(){var a=function(f,q){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var p in f)f.hasOwnProperty(p)&&(a[p]=f[p])};return a(f,q)};return function(f,q){function u(){this.constructor=f}a(f,q);f.prototype=null===q?Object.create(q):(u.prototype=q.prototype,new u)}}(),f=q.isNumber;return function(a){function q(){var f=null!==a&&a.apply(this,arguments)||this;f.options=void 0;f.series=void 0;f.ttBelow=!1;return f}y(q,a);q.prototype.isValid=function(){return f(this.y)||"undefined"===typeof this.y};
q.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return q}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",
fontWeight:"bold"}}});C(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"]],function(a){var q;(function(q){function f(a,f,q,p,e){var k=e&&e.anchorX||a;e=e&&e.anchorY||f;var t=this.circle(k-1,e-1,2,2);t.push(["M",k,e],["L",a,f+p],["L",a,f],["L",a+q,f],["L",a+q,f+p],["L",a,f+p],["Z"]);return t}function u(a,f){a[f+"pin"]=function(q,p,e,k,t){var c=t&&t.anchorX;t=t&&t.anchorY;"circle"===f&&k>e&&(q-=Math.round((k-e)/2),e=k);var r=a[f](q,p,e,k);if(c&&t){var g=c;"circle"===f?g=q+e/2:
(q=r[0],e=r[1],"M"===q[0]&&"L"===e[0]&&(g=(q[1]+e[1])/2));r.push(["M",g,p>t?p:p+k],["L",c,t]);r=r.concat(a.circle(c-1,t-1,2,2))}return r}}var B=[];q.compose=function(q){if(-1===B.indexOf(q)){B.push(q);var w=q.prototype.symbols;w.flag=f;u(w,"circle");u(w,"square")}var r=a.getRendererType();B.indexOf(r)&&(B.push(r),w=q.prototype.symbols,q=r.prototype.symbols,q.circlepin=w.circlepin,q.flag=w.flag.bind(w),q.squarepin=w.squarepin)}})(q||(q={}));return q});C(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y){var f=a.prototype,u=q.prototype,B=y.defined,w=y.stableSort,z;(function(a){function p(){return u.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)}function e(){f.translate.apply(this);var a=this,c=a.options,e=a.chart,g=a.points,k=c.onSeries,p=(k=k&&e.get(k))&&k.options.step,q=k&&k.points,r=e.inverted,x=a.xAxis,u=a.yAxis;e=g.length-1;var v;c=c.onKey||"y";var n=q&&q.length,d=0,h;if(k&&k.visible&&n){d=
(k.pointXOffset||0)+(k.barW||0)/2;var b=k.currentDataGrouping;var m=q[n-1].x+(b?b.totalRange:0);w(g,function(a,b){return a.x-b.x});for(c="plot"+c[0].toUpperCase()+c.substr(1);n--&&g[e];){var l=q[n];b=g[e];b.y=l.y;if(l.x<=b.x&&"undefined"!==typeof l[c]){if(b.x<=m&&(b.plotY=l[c],l.x<b.x&&!p&&(h=q[n+1])&&"undefined"!==typeof h[c])){var A=(b.x-l.x)/(h.x-l.x);b.plotY+=A*(h[c]-l[c]);b.y+=A*(h.y-l.y)}e--;n++;if(0>e)break}}}g.forEach(function(b,c){b.plotX+=d;if("undefined"===typeof b.plotY||r)0<=b.plotX&&
b.plotX<=x.len?r?(b.plotY=x.translate(b.x,0,1,0,1),b.plotX=B(b.y)?u.translate(b.y,0,0,0,1):0):b.plotY=(x.opposite?0:a.yAxis.len)+x.offset:b.shapeArgs={};if((v=g[c-1])&&v.plotX===b.plotX){"undefined"===typeof v.stackIndex&&(v.stackIndex=0);var e=v.stackIndex+1}b.stackIndex=e});this.onSeries=k}var k=[];a.compose=function(a){if(-1===k.indexOf(a)){k.push(a);var c=a.prototype;c.getPlotBox=p;c.translate=e}return a};a.getPlotBox=p;a.translate=e})(z||(z={}));return z});C(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],
a["Series/Flags/FlagsSeriesDefaults.js"],a["Series/Flags/FlagsSymbols.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,y,f,u,B,w,z,r){var p=this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};
return a(c,e)};return function(c,e){function f(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}();f=f.noop;var e=B.distribute,k=w.series,t=w.seriesTypes.column,c=r.addEvent,E=r.defined;B=r.extend;var g=r.merge,D=r.objectEach,C=r.wrap;r=function(a){function f(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}p(f,a);f.prototype.animate=function(a){a&&this.setClip()};f.prototype.drawPoints=function(){var a=
this.points,c=this.chart,f=c.renderer,n=c.inverted,d=this.options,h=d.y,b=this.yAxis,m={},l=[],k;for(k=a.length;k--;){var p=a[k];var q=(n?p.plotY:p.plotX)>this.xAxis.len;var t=p.plotX;var r=p.stackIndex;var u=p.options.shape||d.shape;var w=p.plotY;"undefined"!==typeof w&&(w=p.plotY+h-("undefined"!==typeof r&&r*d.stackDistance));p.anchorX=r?void 0:p.plotX;var B=r?void 0:p.plotY;var y="flag"!==u;r=p.graphic;"undefined"!==typeof w&&0<=t&&!q?(r&&p.hasNewShapeType()&&(r=r.destroy()),r||(r=p.graphic=f.label("",
null,null,u,null,null,d.useHTML).addClass("highcharts-point").add(this.markerGroup),p.graphic.div&&(p.graphic.div.point=p),r.isNew=!0),r.attr({align:y?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),c.styledMode||r.attr(this.pointAttribs(p)).css(g(d.style,p.style)).shadow(d.shadow),0<t&&(t-=r.strokeWidth()%2),u={y:w,anchorY:B},d.allowOverlapX&&(u.x=t,u.anchorX=p.anchorX),r.attr({text:p.options.title||d.title||"A"})[r.isNew?"attr":"animate"](u),d.allowOverlapX||(m[p.plotX]?
m[p.plotX].size=Math.max(m[p.plotX].size,r.width):m[p.plotX]={align:y?.5:0,size:r.width,target:t,anchorX:t}),p.tooltipPos=[t,w+b.pos-c.plotTop]):r&&(p.graphic=r.destroy())}if(!d.allowOverlapX){var F=100;D(m,function(a){a.plotX=a.anchorX;l.push(a);F=Math.max(a.size,F)});e(l,n?b.len:this.xAxis.len,F);for(c=0;c<a.length;c++)f=a[c],h=f.plotX,(h=(n=f.graphic)&&m[h])&&n&&(E(h.pos)?n[n.isNew?"attr":"animate"]({x:h.pos+(h.align||0)*h.size,anchorX:f.anchorX}).show().isNew=!1:n.hide().isNew=!0)}d.useHTML&&
this.markerGroup&&C(this.markerGroup,"on",function(a){return z.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};f.prototype.drawTracker=function(){var e=this.points;a.prototype.drawTracker.call(this);for(var f=function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=c(d.element,"mouseover",function(){0<a.stackIndex&&!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);for(var c=0;c<e.length;c++){var b=e[c];b!==a&&b.raised&&
b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)}}))},g=0;g<e.length;g++)f(e[g])};f.prototype.pointAttribs=function(a,c){var e=this.options,f=a&&a.color||this.color,d=e.lineColor,g=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;c&&(a=e.states[c].fillColor,d=e.states[c].lineColor,g=e.states[c].lineWidth);return{fill:a||f,stroke:d||f,"stroke-width":g||e.lineWidth||0}};f.prototype.setClip=function(){k.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&
this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};f.compose=y.compose;f.defaultOptions=g(t.defaultOptions,q);return f}(t);u.compose(r);B(r.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:f,init:k.prototype.init,invertGroups:f});w.registerSeriesType("flags",r);"";return r});C(a,"Core/Chart/StockChart.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],
a["Core/Defaults.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,q,y,f,u,B,w,z,r,p){function e(a,c){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:v(c.opposite,!0),showLastLabel:!(!c.categories&&
"category"!==c.type),title:{text:null}}:{}}function k(a,c){return"xAxis"===a?(a={type:"datetime",categories:void 0},v(c.navigator&&c.navigator.enabled,u.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}var t=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=
null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),c=y.format,E=f.getOptions;y=p.addEvent;var g=p.clamp,D=p.defined,C=p.extend,O=p.find,F=p.isNumber,x=p.isString,G=p.merge,v=p.pick,n=p.splat;p=function(a){function c(){return null!==a&&a.apply(this,arguments)||this}t(c,a);c.prototype.init=function(b,c){var d=E(),f=b.xAxis,g=b.yAxis,h=v(b.navigator&&b.navigator.enabled,u.enabled,!0);b.xAxis=b.yAxis=void 0;h=G({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:h},
scrollbar:{enabled:v(w.enabled,!0)},rangeSelector:{enabled:v(B.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:v(d.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=f;b.yAxis=g;h.xAxis=n(b.xAxis||{}).map(function(a,c){return G(e("xAxis",a),d.xAxis,d.xAxis&&d.xAxis[c],a,k("xAxis",b))});h.yAxis=n(b.yAxis||{}).map(function(a,b){return G(e("yAxis",a),d.yAxis,d.yAxis&&d.yAxis[b],a)});a.prototype.init.call(this,h,c)};c.prototype.createAxis=function(b,c){c.axis=G(e(b,
c.axis),c.axis,k(b,this.userOptions));return a.prototype.createAxis.call(this,b,c)};return c}(q);(function(a){a.stockChart=function(c,b,d){return new a(c,b,d)}})(p||(p={}));y(z,"setOptions",function(a){var c;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?c={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(c={marker:{enabled:!1,radius:2}}),c&&(a.plotOptions[this.type]=G(a.plotOptions[this.type],c)))});y(a,"autoLabelAlign",function(a){var c=this.chart,b=this.options;
c=c._labelPanes=c._labelPanes||{};var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(b=b.top+","+b.height,!c[b]&&d.enabled&&(15===d.x&&(d.x=0),"undefined"===typeof d.align&&(d.align="right"),c[b]=this,a.align="right",a.preventDefault()))});y(a,"destroy",function(){var a=this.chart,c=this.options&&this.options.top+","+this.options.height;c&&a._labelPanes&&a._labelPanes[c]===this&&delete a._labelPanes[c]});y(a,"getPlotLinePath",function(a){function c(a){var c="xAxis"===a?"yAxis":
"xAxis";a=b.options[c];return F(a)?[e[c][a]]:x(a)?[e.get(a)]:d.map(function(a){return a[c]})}var b=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,e=b.chart,f=e.renderer,k=b.left,n=b.top,p,q,r,t,u=[],w=[],z=a.translatedValue,B=a.value,y=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===b.coll||"yAxis"===b.coll){a.preventDefault();w=c(b.coll);var E=b.isXAxis?e.yAxis:e.xAxis;E.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var c=a.isXAxis?
"yAxis":"xAxis";c=D(a.options[c])?e[c][a.options[c]]:e[c][0];b===c&&w.push(a)}});var C=w.length?[]:[b.isXAxis?e.yAxis[0]:e.xAxis[0]];w.forEach(function(a){-1!==C.indexOf(a)||O(C,function(b){return b.pos===a.pos&&b.len===a.len})||C.push(a)});var G=v(z,b.translate(B,void 0,void 0,a.old));F(G)&&(b.horiz?C.forEach(function(a){var c;q=a.pos;t=q+a.len;p=r=Math.round(G+b.transB);"pass"!==y&&(p<k||p>k+b.width)&&(y?p=r=g(p,k,k+b.width):c=!0);c||u.push(["M",p,q],["L",r,t])}):C.forEach(function(a){var c;p=a.pos;
r=p+a.len;q=t=Math.round(n+b.height-G);"pass"!==y&&(q<n||q>n+b.height)&&(y?q=t=g(q,n,n+b.height):c=!0);c||u.push(["M",p,q],["L",r,t])}));a.path=0<u.length?f.crispPolyLine(u,a.lineWidth||1):null}});r.prototype.crispPolyLine=function(a,c){for(var b=0;b<a.length;b+=2){var d=a[b],e=a[b+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-c%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+c%2/2)}return a};y(a,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});y(a,"afterDrawCrosshair",
function(a){var d,b;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&F(this.min)&&F(this.max)){var e=this.chart,f=this.logarithmic,g=this.crosshair.label,k=this.horiz,n=this.opposite,p=this.left,q=this.top,r=this.crossLabel,t=g.format,u="",w="inside"===this.options.tickPosition,x=!1!==this.crosshair.snap,z=0,y=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,E=this.max;f&&(B=f.lin2log(B),E=f.lin2log(E));f=k?"center":n?"right"===this.labelAlign?"right":"left":
"left"===this.labelAlign?"left":"center";r||(r=this.crossLabel=e.renderer.label("",0,void 0,g.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:g.align||f,padding:v(g.padding,8),r:v(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||r.attr({fill:g.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(C({color:"#ffffff",
fontWeight:"normal",fontSize:"11px",textAlign:"center"},g.style||{})));k?(f=x?(a.plotX||0)+p:y.chartX,q+=n?0:this.height):(f=n?this.width+p:0,q=x?(a.plotY||0)+q:y.chartY);t||g.formatter||(this.dateTime&&(u="%b %d, %Y"),t="{value"+(u?":"+u:"")+"}");u=x?this.isXAxis?a.x:a.y:this.toValue(k?y.chartX:y.chartY);x=a&&a.series?a.series.isPointInside(a):F(u)&&u>B&&u<E;y="";t?y=c(t,{value:u},e):g.formatter&&F(u)&&(y=g.formatter.call(this,u));r.attr({text:y,x:f,y:q,visibility:x?"inherit":"hidden"});g=r.getBBox();
if(F(r.y))if(k){if(w&&!n||!w&&n)q=r.y-g.height}else q=r.y-g.height/2;k?(d=p-g.x,b=p+this.width-g.x):(d="left"===this.labelAlign?p:0,b="right"===this.labelAlign?p+this.width:e.chartWidth);r.translateX<d&&(z=d-r.translateX);r.translateX+g.width>=b&&(z=-(r.translateX+g.width-b));r.attr({x:f+z,y:q,anchorX:k?f:this.opposite?0:e.chartWidth,anchorY:k?this.opposite?e.chartHeight:0:q+g.height/2})}});z.prototype.forceCropping=function(){var a=this.chart,c=this.options.dataGrouping;return!1!==this.allowDG&&
c&&v(c.enabled,a.options.isStock)};y(q,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(G(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return p});C(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Series/DataModifyComposition.js"],a["Stock/Navigator/Navigator.js"],a["Stock/RangeSelector/RangeSelector.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Axis/OrdinalAxis.js"],a["Series/OHLC/OHLCSeries.js"],a["Series/Flags/FlagsSeries.js"],
a["Core/Chart/StockChart.js"]],function(a,q,y,f,u,B,w,z,r){a.Navigator=y;a.RangeSelector=f;a.Scrollbar=u;a.StockChart=a.stockChart=r.stockChart;q.compose(a.Series,a.Axis,a.Point);z.compose(a.Renderer);y.compose(a.Axis,a.Chart,a.Series);w.compose(a.Series);B.compose(a.Axis,a.Series,a.Chart);f.compose(a.Axis,a.Chart);u.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map