/*
 Highcharts JS v10.3.1 (2022-10-31)

 Wind barb series module

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/windbarb",["highcharts"],function(g){a(g);a.Highcharts=g;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function g(a,e,c,g){a.hasOwnProperty(e)||(a[e]=g.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:a[e]}})))}a=a?a._modules:{};g(a,
"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});g(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,e,c){var g=a.prototype,q=e.prototype,d=c.defined,x=c.stableSort,m;(function(a){function m(){return q.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)}function e(){g.translate.apply(this);var a=this,k=a.options,t=a.chart,u=a.points,b=k.onSeries,n=(b=b&&t.get(b))&&
b.options.step,h=b&&b.points,z=t.inverted,f=a.xAxis,m=a.yAxis;t=u.length-1;var e;k=k.onKey||"y";var c=h&&h.length,q=0,r;if(b&&b.visible&&c){q=(b.pointXOffset||0)+(b.barW||0)/2;var l=b.currentDataGrouping;var w=h[c-1].x+(l?l.totalRange:0);x(u,function(b,h){return b.x-h.x});for(k="plot"+k[0].toUpperCase()+k.substr(1);c--&&u[t];){var p=h[c];l=u[t];l.y=p.y;if(p.x<=l.x&&"undefined"!==typeof p[k]){if(l.x<=w&&(l.plotY=p[k],p.x<l.x&&!n&&(r=h[c+1])&&"undefined"!==typeof r[k])){var v=(l.x-p.x)/(r.x-p.x);l.plotY+=
v*(r[k]-p[k]);l.y+=v*(r.y-p.y)}t--;c++;if(0>t)break}}}u.forEach(function(b,h){b.plotX+=q;if("undefined"===typeof b.plotY||z)0<=b.plotX&&b.plotX<=f.len?z?(b.plotY=f.translate(b.x,0,1,0,1),b.plotX=d(b.y)?m.translate(b.y,0,0,0,1):0):b.plotY=(f.opposite?0:a.yAxis.len)+f.offset:b.shapeArgs={};if((e=u[h-1])&&e.plotX===b.plotX){"undefined"===typeof e.stackIndex&&(e.stackIndex=0);var n=e.stackIndex+1}b.stackIndex=n});this.onSeries=b}var c=[];a.compose=function(a){if(-1===c.indexOf(a)){c.push(a);var d=a.prototype;
d.getPlotBox=m;d.translate=e}return a};a.getPlotBox=m;a.translate=e})(m||(m={}));return m});g(a,"Series/Windbarb/WindbarbPoint.js",[a["Core/Utilities.js"],a["Series/Column/ColumnSeries.js"]],function(a,e){var c=this&&this.__extends||function(){var a=function(d,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var c in d)d.hasOwnProperty(c)&&(a[c]=d[c])};return a(d,c)};return function(d,c){function e(){this.constructor=d}a(d,c);d.prototype=
null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),g=a.isNumber;return function(a){function d(){var c=null!==a&&a.apply(this,arguments)||this;c.beaufort=void 0;c.beaufortLevel=void 0;c.direction=void 0;c.options=void 0;c.series=void 0;return c}c(d,a);d.prototype.isValid=function(){return g(this.value)&&0<=this.value};return d}(e.prototype.pointClass)});g(a,"Series/Windbarb/WindbarbSeries.js",[a["Core/Animation/AnimationUtilities.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],
a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"],a["Series/Windbarb/WindbarbPoint.js"]],function(a,e,c,g,q,d,x){var m=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var h in a)a.hasOwnProperty(h)&&(b[h]=a[h])};return a(c,b)};return function(c,b){function n(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(n.prototype=
b.prototype,new n)}}(),r=a.animObject;a=c.noop;var v=q.series,y=q.seriesTypes.column,w=d.extend,A=d.merge,k=d.pick;d=function(a){function d(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}m(d,a);d.registerApproximation=function(){e.windbarb||(e.windbarb=function(a,d){var b=0,n=0,f,e=a.length;for(f=0;f<e;f++)b+=a[f]*Math.cos(d[f]*c.deg2rad),n+=a[f]*Math.sin(d[f]*c.deg2rad);return[a.reduce(function(a,b){return a+b},0)/a.length,Math.atan2(n,b)/
c.deg2rad]})};d.prototype.init=function(a,c){d.registerApproximation();v.prototype.init.call(this,a,c)};d.prototype.pointAttribs=function(a,c){var b=this.options;a=a.color||this.color;var d=this.options.lineWidth;c&&(a=b.states[c].color||a,d=(b.states[c].lineWidth||d)+(b.states[c].lineWidthPlus||0));return{stroke:a,"stroke-width":d}};d.prototype.windArrow=function(a){var b=1.943844*a.value,c=this.options.vectorLength/20,d=-10;if(a.isNull)return[];if(0===a.beaufortLevel)return this.chart.renderer.symbols.circle(-10*
c,-10*c,20*c,20*c);a=[["M",0,7*c],["L",-1.5*c,7*c],["L",0,10*c],["L",1.5*c,7*c],["L",0,7*c],["L",0,-10*c]];var f=(b-b%50)/50;if(0<f)for(;f--;)a.push(-10===d?["L",0,d*c]:["M",0,d*c],["L",5*c,d*c+2],["L",0,d*c+4]),b-=50,d+=7;f=(b-b%10)/10;if(0<f)for(;f--;)a.push(-10===d?["L",0,d*c]:["M",0,d*c],["L",7*c,d*c]),b-=10,d+=3;f=(b-b%5)/5;if(0<f)for(;f--;)a.push(-10===d?["L",0,d*c]:["M",0,d*c],["L",4*c,d*c]),b-=5,d+=3;return a};d.prototype.drawPoints=function(){var a=this.chart,c=this.yAxis,d=a.inverted,e=
this.options.vectorLength/2;this.points.forEach(function(b){var f=b.plotX,h=b.plotY;!1===this.options.clip||a.isInsidePlot(f,0)?(b.graphic||(b.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+k(b.colorIndex,b.series.colorIndex))),b.graphic.attr({d:this.windArrow(b),translateX:f+this.options.xOffset,translateY:h+this.options.yOffset,rotation:b.direction}),this.chart.styledMode||b.graphic.attr(this.pointAttribs(b))):b.graphic&&(b.graphic=b.graphic.destroy());
b.tooltipPos=[f+this.options.xOffset+(d&&!this.onSeries?e:0),h+this.options.yOffset-(d?0:e+c.pos-a.plotTop)]},this)};d.prototype.animate=function(a){a?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},r(this.options.animation))};d.prototype.markerAttribs=function(a,c){return{}};d.prototype.getExtremes=function(){return{}};d.prototype.shouldShowTooltip=function(b,c,d){void 0===d&&(d={});d.ignoreX=this.chart.inverted;d.ignoreY=!d.ignoreX;return a.prototype.shouldShowTooltip.call(this,
b,c,d)};d.defaultOptions=A(y.defaultOptions,{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0});return d}(y);g.compose(d);w(d.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:"Calm;Light air;Light breeze;Gentle breeze;Moderate breeze;Fresh breeze;Strong breeze;Near gale;Gale;Strong gale;Storm;Violent storm;Hurricane".split(";"),
parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:x,trackerGroups:["markerGroup"],invertGroups:a,translate:function(){var a=this.beaufortFloor,c=this.beaufortName;g.translate.call(this);this.points.forEach(function(b){for(var d=0;d<a.length&&!(a[d]>b.value);d++);b.beaufortLevel=d-1;b.beaufort=c[d-1]})}});d.registerApproximation();q.registerSeriesType("windbarb",d);"";return d});g(a,"masters/modules/windbarb.src.js",[],function(){})});
//# sourceMappingURL=windbarb.js.map